/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.sound;

import com.agateau.utils.Assert;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import java.util.HashMap;

public class SoundAtlas {
    private final FileHandle mRootDir;
    private final HashMap<String, Sound> mSounds = new HashMap();

    public SoundAtlas(FileHandle rootDir) {
        this.mRootDir = rootDir;
    }

    public Sound get(String name) {
        Sound sound = this.mSounds.get(name);
        if (sound == null) {
            throw new RuntimeException("Sound '" + name + "' not found");
        }
        return sound;
    }

    public boolean contains(String name) {
        return this.mSounds.containsKey(name);
    }

    public void load(String filename) {
        this.load(filename, "");
    }

    public void load(String filename, String name) {
        FileHandle file = this.mRootDir.child(filename);
        Assert.check(file.exists(), "No sound named " + filename + " in " + this.mRootDir.path(), new Object[0]);
        if ("".equals(name)) {
            name = file.nameWithoutExtension();
        }
        this.mSounds.put(name, Gdx.audio.newSound(file));
    }
}

