/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.vehicledef;

import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.TextureRegionProvider;
import com.agateau.pixelwheels.utils.StringUtils;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

public class AxleDef {
    private static final float SPLASH_FRAME_DURATION = 0.04f;
    public float width;
    public float y;
    public float steer;
    public float drive;
    public boolean drift;
    public TireSize tireSize;

    public TextureRegion getTexture(TextureRegionProvider provider) {
        return provider.findRegion("tires/" + this.tireSize.name());
    }

    public Animation<TextureRegion> getSplashAnimation(TextureRegionProvider provider) {
        String name = StringUtils.format("tires/%s-splash", this.tireSize.name());
        return new Animation<TextureRegion>(0.04f, provider.findRegions(name));
    }

    public static enum TireSize {
        THIN(0.2f),
        NORMAL(0.2f),
        LARGE(0.2f),
        HUGE(0.05f);

        private final float mDensityFactor;

        private TireSize(float densityFactor) {
            this.mDensityFactor = densityFactor;
        }

        public float getDensity() {
            return this.mDensityFactor * (float)GamePlay.instance.tireBaseDensity;
        }
    }
}

