/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.anchor;

import com.agateau.ui.anchor.AnchorRule;
import com.badlogic.gdx.scenes.scene2d.Actor;

public class EdgeRule
implements AnchorRule {
    private final Actor mTarget;
    private final Actor mReference;
    private final Edge mTargetEdge;
    private final Edge mReferenceEdge;

    public EdgeRule(Actor target, Edge targetEdge, Actor reference, Edge referenceEdge) {
        this.mTarget = target;
        this.mReference = reference;
        this.mTargetEdge = targetEdge;
        this.mReferenceEdge = referenceEdge;
    }

    @Override
    public Actor getTarget() {
        return this.mTarget;
    }

    @Override
    public void apply() {
        float value = 0.0f;
        switch (this.mReferenceEdge) {
            case TOP: {
                value = this.mReference.getTop();
                break;
            }
            case RIGHT: {
                value = this.mReference.getRight();
                break;
            }
            case BOTTOM: {
                value = this.mReference.getY();
                break;
            }
            case LEFT: {
                value = this.mReference.getX();
            }
        }
        switch (this.mTargetEdge) {
            case TOP: {
                this.mTarget.setHeight(value - this.mTarget.getY());
                break;
            }
            case RIGHT: {
                this.mTarget.setWidth(value - this.mTarget.getX());
                break;
            }
            case BOTTOM: {
                float top = this.mTarget.getTop();
                this.mTarget.setY(value);
                this.mTarget.setHeight(top - value);
                break;
            }
            case LEFT: {
                float right = this.mTarget.getRight();
                this.mTarget.setX(value);
                this.mTarget.setWidth(right - value);
            }
        }
    }

    public static enum Edge {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

