/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.menu;

import com.agateau.pixelwheels.utils.DrawUtils;
import com.agateau.ui.menu.Menu;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;

class FocusIndicator {
    private static final float IN_ANIMATION_DURATION = 0.1f;
    private static final float OUT_ANIMATION_DURATION = 0.4f;
    private static final float BLINK_DEPTH = 0.3f;
    private static final float BLINK_DURATION = 1.5f;
    private final Color mOldBatchColor = new Color();
    private final Menu.MenuStyle mMenuStyle;
    private final int mExtraPadding;
    private boolean mFocused = false;
    private float mAlpha = 0.0f;
    private float mBlinkT = 0.0f;

    FocusIndicator(Menu menu) {
        this(menu.getMenuStyle());
    }

    FocusIndicator(Menu.MenuStyle menuStyle) {
        this(menuStyle, 0);
    }

    FocusIndicator(Menu.MenuStyle menuStyle, int extraPadding) {
        this.mMenuStyle = menuStyle;
        this.mExtraPadding = extraPadding;
    }

    public void act(float delta) {
        if (this.mFocused) {
            this.mBlinkT += delta;
            if (this.mBlinkT > 1.5f) {
                this.mBlinkT -= 1.5f;
            }
        }
        if (this.mFocused && this.mAlpha < 1.0f) {
            this.mAlpha += delta / 0.1f;
        } else if (!this.mFocused && this.mAlpha > 0.0f) {
            this.mAlpha -= delta / 0.4f;
        }
        this.mAlpha = MathUtils.clamp(this.mAlpha, 0.0f, 1.0f);
    }

    public void draw(Batch batch, float x, float y, float width, float height) {
        if (this.mAlpha == 0.0f) {
            return;
        }
        float k = MathUtils.sin(this.mBlinkT * ((float)Math.PI * 2) / 1.5f);
        float alpha = this.mAlpha * (0.85f + 0.15f * k);
        this.drawIndicator(batch, x, y, width, height, alpha);
    }

    public void drawIndicator(Batch batch, float x, float y, float width, float height, float alpha) {
        this.mOldBatchColor.set(batch.getColor());
        batch.setColor(alpha, alpha, alpha, alpha);
        int padding = this.mMenuStyle.focusPadding + this.mExtraPadding;
        DrawUtils.drawPixelAligned(batch, this.mMenuStyle.focus, x, y, width, height, padding);
        batch.setColor(this.mOldBatchColor);
    }

    public void setFocused(boolean focused) {
        this.mFocused = focused;
        if (this.mFocused) {
            this.mBlinkT = 0.0f;
        }
    }
}

