/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.bonus;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.bonus.ClosestRacerFinder;
import com.agateau.pixelwheels.bonus.MissileGuidingSystem;
import com.agateau.pixelwheels.debug.DebugShapeMap;
import com.agateau.pixelwheels.gameobject.AnimationObject;
import com.agateau.pixelwheels.gameobject.AudioClipper;
import com.agateau.pixelwheels.gameobject.Explosable;
import com.agateau.pixelwheels.gameobject.GameObjectAdapter;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.racescreen.Collidable;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.sound.SoundPlayer;
import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.pixelwheels.utils.BodyRegionDrawer;
import com.agateau.pixelwheels.utils.Box2DUtils;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.joints.WeldJointDef;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.ReflectionPool;

public class Missile
extends GameObjectAdapter
implements Collidable,
Pool.Poolable,
Disposable,
Explosable {
    private static final ReflectionPool<Missile> sPool = new ReflectionPool<Missile>(Missile.class);
    private static final float WIDTH = 44.0f;
    private static final float HEIGHT = 13.0f;
    private static final float DURATION = 3.0f;
    private static final float LOCK_DISTANCE = 40.0f;
    private static final float LOCK_ARC = 120.0f;
    private static final float WAITING_DENSITY = 1.0E-7f;
    private static final float SHOT_DENSITY = 1.0E-4f;
    private static final Color TARGETED_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.7f);
    private static final Color LOCKED_COLOR = new Color(1.0f, 0.3f, 0.3f, 0.9f);
    private final BodyDef mBodyDef = new BodyDef();
    private final WeldJointDef mJointDef = new WeldJointDef();
    private final PolygonShape mShape = new PolygonShape();
    private final BodyRegionDrawer mDrawer = new BodyRegionDrawer();
    private final ClosestRacerFinder mRacerFinder = new ClosestRacerFinder(40.0f, 120.0f);
    private final MissileGuidingSystem mGuidingSystem = new MissileGuidingSystem();
    private Assets mAssets;
    private SoundPlayer mSoundPlayer;
    private final DebugShapeMap.Shape mDebugShape = new DebugShapeMap.Shape(){

        @Override
        public void draw(ShapeRenderer renderer) {
            renderer.begin(ShapeRenderer.ShapeType.Line);
            renderer.setColor(1.0f, 0.0f, 0.0f, 1.0f);
            Vector2 origin = Missile.this.mBody.getWorldCenter();
            float angle = Missile.this.mBody.getAngle() * 57.295776f;
            renderer.line(origin, Missile.this.mRacerFinder.getLeftVertex(origin, angle));
            renderer.line(origin, Missile.this.mRacerFinder.getRightVertex(origin, angle));
            renderer.end();
        }
    };
    private GameWorld mGameWorld;
    private AudioManager mAudioManager;
    private Racer mShooter;
    private Body mBody;
    private float mTime;
    private Joint mJoint;
    private Status mStatus;
    private boolean mNeedShootSound;
    private Racer mTarget;

    public Missile() {
        this.mBodyDef.type = BodyDef.BodyType.DynamicBody;
        this.mBodyDef.bullet = true;
        this.mShape.setAsBox(1.1f, 0.32500002f);
    }

    public static Missile create(Assets assets, GameWorld gameWorld, AudioManager audioManager, Racer shooter) {
        Missile object = (Missile)sPool.obtain();
        object.mAssets = assets;
        object.mGameWorld = gameWorld;
        object.mAudioManager = audioManager;
        object.setFinished(false);
        object.mRacerFinder.setIgnoredRacer(shooter);
        Vehicle vehicle = shooter.getVehicle();
        object.mShooter = shooter;
        object.mBodyDef.position.set(vehicle.getX(), vehicle.getY());
        object.mBodyDef.angle = vehicle.getAngle() * ((float)Math.PI / 180);
        object.mBody = gameWorld.getBox2DWorld().createBody(object.mBodyDef);
        object.mBody.createFixture(object.mShape, 1.0E-7f);
        object.mBody.setUserData(object);
        Box2DUtils.setCollisionInfo(object.mBody, 4, 11);
        object.mStatus = Status.WAITING;
        if (object.mSoundPlayer == null) {
            object.mSoundPlayer = audioManager.createSoundPlayer(assets.soundAtlas.get("missile"));
        }
        object.mNeedShootSound = false;
        object.mTarget = null;
        object.initJoint();
        object.mGuidingSystem.init(object.mBody);
        gameWorld.addGameObject(object);
        DebugShapeMap.put(object, object.mDebugShape);
        return object;
    }

    public boolean hasTarget() {
        return this.mTarget != null;
    }

    private void initJoint() {
        Body vehicleBody;
        Vehicle vehicle = this.mShooter.getVehicle();
        this.mJointDef.bodyA = vehicleBody = vehicle.getBody();
        this.mJointDef.bodyB = this.mBody;
        this.mJointDef.localAnchorA.set(vehicleBody.getLocalCenter());
        this.mJointDef.localAnchorB.set(this.mBody.getLocalCenter());
        this.mJoint = this.mGameWorld.getBox2DWorld().createJoint(this.mJointDef);
    }

    public void shoot() {
        this.resetJoint();
        this.mBody.getFixtureList().first().setDensity(1.0E-4f);
        this.mBody.resetMassData();
        this.mBody.setAngularVelocity(0.0f);
        this.mStatus = Status.SHOT;
        this.mTime = 0.0f;
        this.mNeedShootSound = true;
    }

    @Override
    public void reset() {
        this.mGameWorld.getBox2DWorld().destroyBody(this.mBody);
        this.mBody = null;
        DebugShapeMap.remove(this);
    }

    private void resetJoint() {
        if (this.mJoint != null) {
            this.mGameWorld.getBox2DWorld().destroyJoint(this.mJoint);
            this.mJoint = null;
        }
    }

    @Override
    public void dispose() {
        sPool.free(this);
    }

    @Override
    public void act(float delta) {
        switch (this.mStatus) {
            case WAITING: {
                this.actWaiting();
                break;
            }
            case SHOT: {
                this.actShot(delta);
                break;
            }
            case LOCKED: {
                this.actLocked(delta);
            }
        }
    }

    private void actWaiting() {
        this.findTarget();
    }

    private void actShot(float delta) {
        this.findTarget();
        if (this.mTarget != null) {
            this.mStatus = Status.LOCKED;
        }
        this.mGuidingSystem.act(null);
        this.consumeTime(delta);
    }

    private void actLocked(float delta) {
        this.mGuidingSystem.act(this.mTarget.getPosition());
        this.consumeTime(delta);
    }

    private void consumeTime(float delta) {
        this.mTime += delta;
        if (this.mTime >= 3.0f) {
            this.explode();
        }
    }

    private void findTarget() {
        World world = this.mGameWorld.getBox2DWorld();
        this.mTarget = this.mRacerFinder.find(world, this.mBody.getWorldCenter(), this.mBody.getAngle() * 57.295776f);
    }

    @Override
    public void draw(Batch batch, ZLevel zLevel, Rectangle viewBounds) {
        if (zLevel == ZLevel.FLYING_LOW) {
            this.drawShadow(batch);
            this.drawMissile(batch);
            this.drawTarget(batch);
            if (this.mStatus != Status.WAITING) {
                this.drawReactorFire(batch);
            }
        }
    }

    private void drawTarget(Batch batch) {
        if (this.mTarget == null) {
            return;
        }
        batch.setColor(this.mStatus == Status.LOCKED ? LOCKED_COLOR : TARGETED_COLOR);
        TextureRegion region = this.mAssets.target;
        float w = 0.05f * (float)region.getRegionWidth();
        float h = 0.05f * (float)region.getRegionHeight();
        batch.draw(region, this.mTarget.getX() - w / 2.0f, this.mTarget.getY() - h / 2.0f, w, h);
        batch.setColor(Color.WHITE);
    }

    private void drawMissile(Batch batch) {
        this.mDrawer.setBatch(batch);
        this.mDrawer.draw(this.mBody, this.mAssets.missile);
    }

    private void drawReactorFire(Batch batch) {
        TextureRegion region = this.mAssets.turboFlame.getKeyFrame(this.mTime, true);
        Vector2 center = this.mBody.getPosition();
        float angle = this.mBody.getAngle();
        float w = 0.05f * (float)region.getRegionWidth();
        float h = 0.05f * (float)region.getRegionHeight();
        float refH = -1.1f;
        float x = center.x + refH * MathUtils.cos(angle);
        float y = center.y + refH * MathUtils.sin(angle);
        batch.draw(region, x - w / 2.0f, y - h, w / 2.0f, h, w, h, 1.0f, 1.0f, angle * 57.295776f - 90.0f);
    }

    private void drawShadow(Batch batch) {
        this.mDrawer.setBatch(batch);
        this.mDrawer.drawShadow(this.mBody, this.mAssets.missile);
    }

    @Override
    public void audioRender(AudioClipper clipper) {
        if (this.mNeedShootSound) {
            this.mSoundPlayer.setVolume(clipper.clip(this));
            this.mSoundPlayer.play();
            this.mNeedShootSound = false;
        }
    }

    @Override
    public float getX() {
        return this.mBody.getPosition().x;
    }

    @Override
    public float getY() {
        return this.mBody.getPosition().y;
    }

    public void remove() {
        this.setFinished(true);
    }

    @Override
    public void explode() {
        Vector2 pos = this.mBody.getPosition();
        AnimationObject obj = this.mAssets.createExplosion(this.mAudioManager, pos.x, pos.y);
        this.mGameWorld.addGameObject(obj);
        this.mSoundPlayer.stop();
        this.setFinished(true);
    }

    @Override
    public void beginContact(Contact contact, Fixture otherFixture) {
    }

    @Override
    public void endContact(Contact contact, Fixture otherFixture) {
    }

    @Override
    public void preSolve(Contact contact, Fixture otherFixture, Manifold oldManifold) {
        if (this.isFinished()) {
            return;
        }
        if (this.mStatus == Status.WAITING) {
            contact.setEnabled(false);
            return;
        }
        Object other = otherFixture.getBody().getUserData();
        if (other == this.mShooter) {
            contact.setEnabled(false);
            return;
        }
        this.explode();
        if (other instanceof Racer) {
            Racer racer = (Racer)other;
            if (!racer.isFinished() && !racer.getLapPositionComponent().hasFinishedRace()) {
                this.mShooter.getGameStats().recordEvent(GameStats.Event.MISSILE_HIT);
            }
            racer.disrupt();
        } else if (other instanceof Explosable) {
            ((Explosable)other).explode();
        }
    }

    @Override
    public void postSolve(Contact contact, Fixture otherFixture, ContactImpulse impulse) {
    }

    static enum Status {
        WAITING,
        SHOT,
        LOCKED;

    }
}

