/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gameinput;

import com.agateau.pixelwheels.gameinput.GameInputHandler;
import com.agateau.pixelwheels.gameinput.GameInputHandlerFactory;
import com.agateau.pixelwheels.gameinput.InputMapperInputHandler;
import com.agateau.translations.Translator;
import com.agateau.ui.GamepadInputMapper;
import com.agateau.ui.GamepadInputMappers;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.utils.Array;

public class GamepadInputHandler
extends InputMapperInputHandler {
    @Override
    public String getName() {
        GamepadInputMapper mapper = (GamepadInputMapper)this.getInputMapper();
        Controller controller = mapper.getController();
        return controller == null ? "" : controller.getName();
    }

    @Override
    public String getTypeName() {
        return Translator.tr("Gamepad");
    }

    private GamepadInputHandler(GamepadInputMapper inputMapper) {
        super(inputMapper);
    }

    public static class Factory
    implements GameInputHandlerFactory {
        final Array<GameInputHandler> mHandlers = new Array();

        Factory() {
            for (GamepadInputMapper inputMapper : GamepadInputMappers.getInstance().getMappers()) {
                this.mHandlers.add(new GamepadInputHandler(inputMapper));
            }
        }

        @Override
        public String getId() {
            return "gamepad";
        }

        @Override
        public String getName() {
            return Translator.tr("Gamepad");
        }

        @Override
        public Array<GameInputHandler> getAllHandlers() {
            return this.mHandlers;
        }
    }
}

