/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gamesetup;

import com.agateau.pixelwheels.Constants;
import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.gamesetup.ChampionshipGameInfo;
import com.agateau.pixelwheels.gamesetup.GameInfo;
import com.agateau.pixelwheels.gamesetup.Maestro;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.racescreen.RaceScreen;
import com.agateau.pixelwheels.screens.ChampionshipFinishedScreen;
import com.agateau.pixelwheels.screens.MultiPlayerScreen;
import com.agateau.pixelwheels.screens.NavStageScreen;
import com.agateau.pixelwheels.screens.SelectChampionshipScreen;
import com.agateau.pixelwheels.screens.SelectVehicleScreen;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.utils.Array;

public class ChampionshipMaestro
extends Maestro {
    private final ChampionshipGameInfo.Builder mGameInfoBuilder;
    private ChampionshipGameInfo mGameInfo;

    public ChampionshipMaestro(PwGame game, int playerCount) {
        super(game, playerCount);
        this.mGameInfoBuilder = new ChampionshipGameInfo.Builder(this.getGame().getAssets().vehicleDefs, this.getGame().getConfig());
    }

    public boolean isFirstTrack() {
        return this.mGameInfo.isFirstTrack();
    }

    @Override
    public void start() {
        this.getGame().pushScreen(this.createChampionshipScreen());
    }

    private Screen createSelectVehicleScreen() {
        if (this.getPlayerCount() == 1) {
            return this.createOnePlayerVehicleScreen();
        }
        return this.createMultiPlayerVehicleScreen();
    }

    private Screen createOnePlayerVehicleScreen() {
        SelectVehicleScreen.Listener listener = new SelectVehicleScreen.Listener(){

            @Override
            public void onBackPressed() {
                ChampionshipMaestro.this.getGame().replaceScreen(ChampionshipMaestro.this.createChampionshipScreen());
            }

            @Override
            public void onPlayerSelected(GameInfo.Player player) {
                Array<GameInfo.Player> players = new Array<GameInfo.Player>();
                players.add(player);
                ChampionshipMaestro.this.mGameInfoBuilder.setPlayers(players);
                ChampionshipMaestro.this.startChampionship();
            }
        };
        return new SelectVehicleScreen(this.getGame(), listener);
    }

    private Screen createMultiPlayerVehicleScreen() {
        MultiPlayerScreen.Listener listener = new MultiPlayerScreen.Listener(){

            @Override
            public void onBackPressed() {
                ChampionshipMaestro.this.getGame().replaceScreen(ChampionshipMaestro.this.createChampionshipScreen());
            }

            @Override
            public void onPlayersSelected(Array<GameInfo.Player> players) {
                ChampionshipMaestro.this.mGameInfoBuilder.setPlayers(players);
                ChampionshipMaestro.this.startChampionship();
            }
        };
        return new MultiPlayerScreen(this.getGame(), this.getPlayerCount(), listener);
    }

    private Screen createChampionshipScreen() {
        GameConfig gameConfig = this.getGame().getConfig();
        SelectChampionshipScreen.Listener listener = new SelectChampionshipScreen.Listener(){

            @Override
            public void onBackPressed() {
                ChampionshipMaestro.this.stopEnoughInputChecker();
                ChampionshipMaestro.this.getGame().popScreen();
            }

            @Override
            public void onChampionshipSelected(Championship championship) {
                ChampionshipMaestro.this.mGameInfoBuilder.setChampionship(championship);
                ChampionshipMaestro.this.getGame().replaceScreen(ChampionshipMaestro.this.createSelectVehicleScreen());
            }
        };
        return new SelectChampionshipScreen(this.getGame(), listener, gameConfig.championship);
    }

    private void startChampionship() {
        this.mGameInfo = this.mGameInfoBuilder.build();
        if (Constants.DEBUG_SCREEN.equals("ChampionshipFinished:podium")) {
            GameInfo.Entrant player = this.mGameInfo.getEntrants().pop();
            this.mGameInfo.getEntrants().insert(0, player);
            this.fillEntrantsWithDebugValues();
            this.getGame().replaceScreen(this.createChampionshipFinishedScreen());
        } else if (Constants.DEBUG_SCREEN.equals("ChampionshipFinished:nopodium")) {
            this.fillEntrantsWithDebugValues();
            this.getGame().replaceScreen(this.createChampionshipFinishedScreen());
        } else {
            this.getGame().replaceScreen(this.createRaceScreen());
        }
    }

    private void fillEntrantsWithDebugValues() {
        float startValue = 345.6789f;
        for (int idx = 0; idx < this.mGameInfo.getEntrants().size; ++idx) {
            GameInfo.Entrant entrant = this.mGameInfo.getEntrants().get(idx);
            entrant.addPoints(12 - idx);
            entrant.addRaceTime((float)(idx + 1) * startValue * 1.1f);
        }
    }

    private Screen createRaceScreen() {
        RaceScreen.Listener listener = new RaceScreen.Listener(){

            @Override
            public void onRestartPressed() {
                throw new RuntimeException("Restart should not be called in championship mode");
            }

            @Override
            public void onQuitPressed() {
                ChampionshipMaestro.this.stopEnoughInputChecker();
                ChampionshipMaestro.this.getGame().showMainMenu();
            }

            @Override
            public void onNextTrackPressed() {
                ChampionshipMaestro.this.mGameInfo.sortEntrants();
                if (ChampionshipMaestro.this.mGameInfo.isLastTrack()) {
                    ChampionshipMaestro.this.getGame().onChampionshipFinished(ChampionshipMaestro.this.mGameInfo);
                    ChampionshipMaestro.this.getGame().replaceScreen(ChampionshipMaestro.this.createChampionshipFinishedScreen());
                } else {
                    ChampionshipMaestro.this.mGameInfo.selectNextTrack();
                    ChampionshipMaestro.this.showUnlockedRewardScreen(() -> ChampionshipMaestro.this.getGame().replaceScreen(ChampionshipMaestro.this.createRaceScreen()));
                }
            }
        };
        return new RaceScreen(this.getGame(), listener, this.mGameInfo);
    }

    private Screen createChampionshipFinishedScreen() {
        NavStageScreen.NextListener navListener = new NavStageScreen.NextListener(){

            @Override
            public void onNextPressed() {
                ChampionshipMaestro.this.showUnlockedRewardScreen(() -> ChampionshipMaestro.this.getGame().showMainMenu());
            }
        };
        return new ChampionshipFinishedScreen(this.getGame(), this.mGameInfo, navListener);
    }
}

