/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Polygon;

public class LapPosition {
    private static final float UNINITIALIZED = -2.0f;
    private int mSectionId = -1;
    private Polygon mSectionPolygon;
    private float mX;
    private float mY;
    private float mSectionDistance;
    private float mCenterDistance = -2.0f;

    public void init(int sectionId, Polygon sectionPolygon, float x, float y, float sectionDistance) {
        this.mSectionId = sectionId;
        this.mSectionPolygon = sectionPolygon;
        this.mX = x;
        this.mY = y;
        this.mSectionDistance = sectionDistance;
        this.mCenterDistance = -2.0f;
    }

    public void copy(LapPosition other) {
        this.mSectionId = other.mSectionId;
        this.mSectionPolygon = other.mSectionPolygon;
        this.mX = other.mX;
        this.mY = other.mY;
        this.mSectionDistance = other.mSectionDistance;
        this.mCenterDistance = other.mCenterDistance;
    }

    public int getSectionId() {
        return this.mSectionId;
    }

    public float getSectionDistance() {
        return this.mSectionDistance;
    }

    public float getLapDistance() {
        return (float)this.mSectionId + this.mSectionDistance;
    }

    public float getCenterDistance() {
        if (this.mCenterDistance < -1.0f) {
            this.computeCenterDistance();
        }
        return this.mCenterDistance;
    }

    private void computeCenterDistance() {
        float[] vertices = this.mSectionPolygon.getTransformedVertices();
        float nx = MathUtils.lerp(vertices[0], vertices[2], this.mSectionDistance);
        float ny = MathUtils.lerp(vertices[1], vertices[3], this.mSectionDistance);
        float lx = MathUtils.lerp(vertices[6], vertices[4], this.mSectionDistance);
        float ly = MathUtils.lerp(vertices[7], vertices[5], this.mSectionDistance);
        float nlLength = LapPosition.computeLength2(nx, ny, lx, ly);
        float nmLength = LapPosition.computeLength2(nx, ny, this.mX, this.mY);
        this.mCenterDistance = (float)Math.sqrt(nmLength / nlLength) * 2.0f - 1.0f;
    }

    private static float computeLength2(float x1, float y1, float x2, float y2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        return dx * dx + dy * dy;
    }
}

