/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.debug.DebugShapeMap;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.map.WaypointStore;
import com.agateau.pixelwheels.racer.AIPilot;
import com.agateau.pixelwheels.racer.Pilot;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.utils.DrawUtils;
import com.agateau.pixelwheels.utils.OrientedPoint;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;

public class RacerDebugShape
implements DebugShapeMap.Shape {
    private final Racer mRacer;
    private final Track mTrack;

    public RacerDebugShape(Racer racer, Track track) {
        this.mRacer = racer;
        this.mTrack = track;
    }

    @Override
    public void draw(ShapeRenderer renderer) {
        Pilot pilot = this.mRacer.getPilot();
        if (pilot instanceof AIPilot) {
            this.renderAITargetPosition(renderer, (AIPilot)pilot);
        } else {
            this.renderWaypoints(renderer);
        }
    }

    private void renderWaypoints(ShapeRenderer renderer) {
        WaypointStore store = this.mTrack.getWaypointStore();
        float lapDistance = this.mRacer.getLapPositionComponent().getLapDistance();
        int nextIdx = store.getWaypointIndex(lapDistance);
        int prevIdx = store.getPreviousIndex(nextIdx);
        OrientedPoint point = store.getValidPosition(this.mRacer.getVehicle().getBody().getWorldCenter(), lapDistance);
        renderer.begin(ShapeRenderer.ShapeType.Line);
        float radius = 0.5f;
        renderer.setColor(1.0f, 1.0f, 0.0f, 1.0f);
        DrawUtils.drawCross(renderer, store.getWaypoint(prevIdx), radius);
        renderer.setColor(0.0f, 1.0f, 1.0f, 1.0f);
        DrawUtils.drawCross(renderer, store.getWaypoint(nextIdx), radius);
        renderer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        DrawUtils.drawCross(renderer, point.x, point.y, radius);
        renderer.end();
    }

    private void renderAITargetPosition(ShapeRenderer renderer, AIPilot pilot) {
        renderer.begin(ShapeRenderer.ShapeType.Line);
        renderer.setColor(1.0f, 0.0f, 1.0f, 1.0f);
        Vector2 targetPosition = pilot.getTargetPosition();
        renderer.line(this.mRacer.getPosition(), targetPosition);
        DrawUtils.drawCross(renderer, targetPosition, 0.6f);
        renderer.end();
    }
}

