/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.racescreen.CameraUpdater;
import com.badlogic.gdx.math.MathUtils;
import java.util.Iterator;

class HeadingUpCameraUpdater
extends CameraUpdater {
    private static final float MAX_ZOOM_SPEED = 75.0f;
    private static final float MIN_ZOOM = 0.6f;
    private static final float MAX_ZOOM = 2.1f;
    private final Racer mRacer;

    HeadingUpCameraUpdater(GameWorld world, Racer racer) {
        super(world);
        this.mRacer = racer;
    }

    @Override
    public void update(float delta) {
        Vehicle vehicle = this.mRacer.getVehicle();
        this.mNextCameraInfo.zoom = MathUtils.lerp(0.6f, 2.1f, vehicle.getSpeed() / 75.0f);
        this.limitZoomChange(delta);
        float viewportWidth = (float)GamePlay.instance.viewportWidth * this.mNextCameraInfo.zoom;
        float viewportHeight = viewportWidth * (float)this.mScreenHeight / (float)this.mScreenWidth;
        this.mNextCameraInfo.viewportWidth = viewportWidth;
        this.mNextCameraInfo.viewportHeight = viewportHeight;
        if (vehicle.isFlying() || vehicle.isFalling()) {
            this.mNextCameraInfo.cameraUp = this.mCameraInfo.cameraUp;
        } else {
            float steerMag = vehicle.isDrifting() ? 0.65f : 0.32f;
            float bodyAngle = vehicle.getBody().getAngle();
            Iterator iterator = vehicle.getWheelInfos().iterator();
            if (iterator.hasNext()) {
                Vehicle.WheelInfo wi = (Vehicle.WheelInfo)iterator.next();
                float wheelAngle = wi.joint.getLowerLimit();
                float targetUp = bodyAngle - steerMag * wheelAngle;
                this.mNextCameraInfo.cameraUp = this.mCameraInfo.cameraUp + 0.12f * (targetUp - this.mCameraInfo.cameraUp);
            }
        }
        float advance = Math.min(viewportWidth, viewportHeight) * 0.25f;
        if (vehicle.isBraking()) {
            advance = (float)((double)advance * 0.8);
        }
        this.mNextCameraInfo.cameraAhead = this.mCameraInfo.cameraAhead + 0.12f * (advance - this.mCameraInfo.cameraAhead);
        this.mNextCameraInfo.position.set(this.mNextCameraInfo.cameraAhead, 0.0f).rotateRad(this.mNextCameraInfo.cameraUp).add(vehicle.getPosition());
        this.limitZoomChange(delta);
        this.applyChanges();
    }
}

