/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.debug.Debug;
import com.agateau.pixelwheels.debug.DebugShapeMap;
import com.agateau.pixelwheels.gameinput.GameInputHandlerFactories;
import com.agateau.pixelwheels.gameobject.AudioClipper;
import com.agateau.pixelwheels.gameobject.GameObject;
import com.agateau.pixelwheels.gamesetup.GameInfo;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.racer.Pilot;
import com.agateau.pixelwheels.racer.PlayerPilot;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.RacerDebugShape;
import com.agateau.pixelwheels.racescreen.CountDownHudController;
import com.agateau.pixelwheels.racescreen.FinishedOverlay;
import com.agateau.pixelwheels.racescreen.GameRenderer;
import com.agateau.pixelwheels.racescreen.GameWorldImpl;
import com.agateau.pixelwheels.racescreen.Hud;
import com.agateau.pixelwheels.racescreen.PauseOverlay;
import com.agateau.pixelwheels.racescreen.RacerHudController;
import com.agateau.pixelwheels.racescreen.debug.DropLocationDebugObject;
import com.agateau.pixelwheels.racescreen.debug.MineDropper;
import com.agateau.pixelwheels.screens.ConfigScreen;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.utils.Assert;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.PerformanceCounter;
import com.badlogic.gdx.utils.PerformanceCounters;
import com.badlogic.gdx.utils.viewport.ScreenViewport;

public class RaceScreen
extends ScreenAdapter {
    private final PwGame mGame;
    private final Listener mListener;
    private final GameInfo mGameInfo;
    private final GameWorldImpl mGameWorld;
    private final Array<GameRenderer> mGameRenderers = new Array();
    private final AudioClipper mAudioClipper;
    private final Array<RacerHudController> mRacerHudControllers = new Array();
    private final ScreenViewport mHudViewport = new ScreenViewport();
    private CountDownHudController mCountDownHudController;
    private final Stage mHudStage;
    private final PerformanceCounters mPerformanceCounters = new PerformanceCounters();
    private final PerformanceCounter mGameWorldPerformanceCounter;
    private final PerformanceCounter mRendererPerformanceCounter;
    private final PerformanceCounter mOverallPerformanceCounter;
    private final PerformanceCounter mHudPerformanceCounter;
    private PauseOverlay mPauseOverlay = null;
    private boolean mFirstRender = true;
    private boolean mConfigVisible = false;

    public RaceScreen(PwGame game, Listener listener, GameInfo gameInfo) {
        NLog.i("Starting race on %s", gameInfo.getTrack().getMapName());
        this.mGame = game;
        this.mListener = listener;
        this.mGameInfo = gameInfo;
        DebugShapeMap.clear();
        this.mOverallPerformanceCounter = this.mPerformanceCounters.add("All");
        this.mGameWorldPerformanceCounter = this.mPerformanceCounters.add("GameWorld.act");
        this.mGameWorld = new GameWorldImpl(game, gameInfo, this.mPerformanceCounters);
        this.mRendererPerformanceCounter = this.mPerformanceCounters.add("Renderer");
        SpriteBatch batch = new SpriteBatch();
        this.mHudStage = new Stage(this.mHudViewport, batch);
        this.mHudStage.setDebugAll(Debug.instance.showHudDebugLines);
        this.createCountDownHudController();
        for (Racer racer : this.mGameWorld.getPlayerRacers()) {
            GameRenderer renderer = new GameRenderer(this.mGameWorld, racer, batch, this.mGame.getConfig().headingUpCamera, this.mPerformanceCounters);
            this.mGameRenderers.add(renderer);
            this.mRacerHudControllers.add(this.createRacerHudController(this.mGameWorld.getTrack(), racer));
        }
        this.createInputUi();
        this.mHudPerformanceCounter = this.mPerformanceCounters.add("Hud");
        this.mAudioClipper = this.createAudioClipper();
        this.setupDebugTools();
    }

    private void startMusic() {
        String musicId = this.mGame.getAssets().getTrackMusicId(this.mGameInfo.getTrack());
        this.mGame.getAudioManager().playMusic(musicId);
    }

    private void setupDebugTools() {
        if (Debug.instance.showDebugHud) {
            GameRenderer gameRenderer = this.mGameRenderers.first();
            RacerHudController controller = this.mRacerHudControllers.first();
            controller.initDebugHud(this.mPerformanceCounters);
            MineDropper dropper = new MineDropper(this.mGame, this.mGameWorld, gameRenderer);
            this.mGameWorld.addGameObject(dropper);
            controller.addDebugActor(dropper.createDebugButton());
            DropLocationDebugObject dropLocationDebugObject = new DropLocationDebugObject(this.mGame.getAssets(), gameRenderer, this.mGameWorld.getTrack());
            this.mGameWorld.addGameObject(dropLocationDebugObject);
            controller.addDebugActor(dropLocationDebugObject.createDebugButton(this.mGame.getAssets().ui.skin));
        }
    }

    private RacerHudController createRacerHudController(Track track, Racer playerRacer) {
        Hud hud = new Hud(this.mGame, this.mHudStage);
        RacerHudController controller = new RacerHudController(this.mGame.getAssets(), this.mGameWorld, hud, playerRacer);
        if (Debug.instance.showDebugLayer) {
            int idx = 0;
            for (Racer racer : this.mGameWorld.getRacers()) {
                DebugShapeMap.put("racer" + idx, new RacerDebugShape(racer, track));
                ++idx;
            }
        }
        return controller;
    }

    private void createCountDownHudController() {
        Hud hud = new Hud(this.mGame, this.mHudStage);
        this.mCountDownHudController = new CountDownHudController(this.mGame.getAssets(), this.mGameWorld, hud);
    }

    private void createInputUi() {
        if (!GameInputHandlerFactories.hasMultitouch()) {
            return;
        }
        RacerHudController racerHudController = this.mRacerHudControllers.first();
        racerHudController.createPauseButton(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                RaceScreen.this.pauseRace();
            }
        });
        Pilot pilot = this.mGameWorld.getPlayerRacer(0).getPilot();
        if (pilot instanceof PlayerPilot) {
            ((PlayerPilot)pilot).createHudButtons(racerHudController.getHud());
        }
    }

    private AudioClipper createAudioClipper() {
        return gameObject -> {
            float maxDistance = GamePlay.instance.viewportWidth;
            float distance2 = maxDistance * maxDistance;
            for (Racer racer : this.mGameWorld.getPlayerRacers()) {
                float dx = racer.getX() - gameObject.getX();
                float dy = racer.getY() - gameObject.getY();
                float d2 = dx * dx + dy * dy;
                distance2 = Math.min(d2, distance2);
            }
            return 1.0f - (float)Math.sqrt(distance2) / maxDistance;
        };
    }

    @Override
    public void render(float delta) {
        if (this.mFirstRender) {
            for (GameRenderer gameRenderer : this.mGameRenderers) {
                gameRenderer.onAboutToStart();
            }
            this.mGame.getAudioManager().fadeOutMusic();
            this.mFirstRender = false;
        }
        boolean paused = this.mPauseOverlay != null;
        this.mOverallPerformanceCounter.start();
        this.mGameWorldPerformanceCounter.start();
        if (!paused) {
            GameWorld.State oldState = this.mGameWorld.getState();
            this.mGameWorld.act(delta);
            GameWorld.State newState = this.mGameWorld.getState();
            if (oldState != newState) {
                if (newState == GameWorld.State.FINISHED) {
                    this.onFinished();
                }
                if (newState == GameWorld.State.RUNNING) {
                    this.startMusic();
                }
            }
        }
        this.mGameWorldPerformanceCounter.stop();
        this.mRendererPerformanceCounter.start();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        for (GameRenderer gameRenderer : this.mGameRenderers) {
            gameRenderer.render(delta);
        }
        for (GameObject gameObject : this.mGameWorld.getActiveGameObjects()) {
            gameObject.audioRender(this.mAudioClipper);
        }
        if (this.isPauseKeyPressed()) {
            if (paused) {
                this.resumeRace();
            } else {
                this.pauseRace();
            }
        }
        this.mRendererPerformanceCounter.stop();
        this.mHudPerformanceCounter.start();
        for (RacerHudController controller : this.mRacerHudControllers) {
            controller.act(delta);
        }
        this.mCountDownHudController.act(delta);
        this.mHudViewport.apply(true);
        this.mHudStage.draw();
        this.mHudStage.act(delta);
        this.mHudPerformanceCounter.stop();
        this.mOverallPerformanceCounter.stop();
        if (!paused) {
            for (PerformanceCounter counter : this.mPerformanceCounters.counters) {
                if (!counter.valid) continue;
                counter.tick(delta);
            }
        }
    }

    private boolean isPauseKeyPressed() {
        for (Racer racer : this.mGameWorld.getPlayerRacers()) {
            PlayerPilot pilot = (PlayerPilot)racer.getPilot();
            if (!pilot.isPauseKeyPressed()) continue;
            return true;
        }
        return Gdx.input.isKeyJustPressed(111) || Gdx.input.isKeyJustPressed(4);
    }

    @Override
    public void resize(int screenW, int screenH) {
        super.resize(screenW, screenH);
        float upp = PwStageScreen.getUnitsPerPixel();
        this.mHudViewport.setUnitsPerPixel(upp);
        Assert.check(this.mGameRenderers.size <= 4, "Unsupported number of renderers", new Object[0]);
        int width = this.mGameRenderers.size == 1 ? screenW : screenW / 2;
        int height = this.mGameRenderers.size < 3 ? screenH : screenH / 2;
        boolean singlePlayer = this.mGameRenderers.size == 1;
        for (int idx = 0; idx < this.mGameRenderers.size; ++idx) {
            int padB;
            int padL;
            int x = idx % 2 * width;
            int y = idx < 2 ? screenH - height : 0;
            int n = padL = x > 0 ? 1 : 0;
            int padR = singlePlayer ? 0 : (x == 0 ? 1 : 0);
            int n2 = padB = y > 0 ? 1 : 0;
            int padT = singlePlayer ? 0 : (y == 0 ? 1 : 0);
            this.mGameRenderers.get(idx).setScreenRect(x + padL, y + padB, width - padL - padR, height - padT - padB);
            Hud hud = this.mRacerHudControllers.get(idx).getHud();
            hud.setScreenRect((int)((float)x * upp), (int)((float)y * upp), (int)((float)width * upp), (int)((float)height * upp));
        }
        this.mCountDownHudController.getHud().setScreenRect(0, 0, (int)((float)screenW * upp), (int)((float)screenH * upp));
        this.mHudViewport.update(screenW, screenH, true);
    }

    private void onFinished() {
        FinishedOverlay overlay = new FinishedOverlay(this.mGame, this, this.mGameWorld.getRacers());
        this.mHudStage.addActor(overlay);
    }

    private void pauseRace() {
        if (this.mGameWorld.getState() == GameWorld.State.FINISHED) {
            return;
        }
        this.mGame.getAudioManager().setSoundFxMuted(true);
        this.mPauseOverlay = new PauseOverlay(this.mGame, this);
        this.mHudStage.addActor(this.mPauseOverlay);
    }

    public void resumeRace() {
        this.mPauseOverlay.remove();
        this.mPauseOverlay = null;
        this.unmuteIfNecessary();
    }

    void onRestartPressed() {
        this.unmuteIfNecessary();
        this.mListener.onRestartPressed();
    }

    void onQuitPressed() {
        this.mListener.onQuitPressed();
    }

    void onSettingsPressed() {
        this.mConfigVisible = true;
        this.mGame.pushScreen(new ConfigScreen(this.mGame, ConfigScreen.Origin.PAUSE_OVERLAY));
    }

    private void unmuteIfNecessary() {
        this.mGame.getAudioManager().setSoundFxMuted(!this.mGame.getConfig().playSoundFx);
    }

    @Override
    public void show() {
        super.show();
        Gdx.input.setInputProcessor(this.mHudStage);
        if (this.mConfigVisible) {
            this.mConfigVisible = false;
            this.createInputUi();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mGameWorld.dispose();
    }

    public void forgetTrack() {
        this.mGameWorld.forgetTrack();
    }

    GameInfo.GameType getGameType() {
        return this.mGameInfo.getGameType();
    }

    public Listener getListener() {
        return this.mListener;
    }

    public static interface Listener {
        public void onRestartPressed();

        public void onQuitPressed();

        public void onNextTrackPressed();
    }
}

