/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.racescreen.CameraUpdater;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;

class RacerCameraUpdater
extends CameraUpdater {
    private static final float MAX_ZOOM_SPEED = 75.0f;
    private static final float MIN_ZOOM = 0.6f;
    private static final float MAX_ZOOM = 2.1f;
    private final Vector2 sDelta = new Vector2();
    private final Racer mRacer;

    RacerCameraUpdater(GameWorld world, Racer racer) {
        super(world);
        this.mRacer = racer;
    }

    @Override
    public void update(float delta) {
        boolean immediate = delta < 0.0f;
        Vehicle vehicle = this.mRacer.getVehicle();
        this.mNextCameraInfo.zoom = MathUtils.lerp(0.6f, 2.1f, vehicle.getSpeed() / 75.0f);
        this.limitZoomChange(delta);
        float viewportWidth = (float)GamePlay.instance.viewportWidth * this.mNextCameraInfo.zoom;
        float viewportHeight = viewportWidth * (float)this.mScreenHeight / (float)this.mScreenWidth;
        this.mNextCameraInfo.viewportWidth = viewportWidth;
        this.mNextCameraInfo.viewportHeight = viewportHeight;
        float advance = Math.min(viewportWidth, viewportHeight) * 0.25f;
        this.sDelta.set(advance, 0.0f).rotate(this.mRacer.getCameraAngle()).add(vehicle.getPosition()).sub(this.mCameraInfo.position);
        this.mNextCameraInfo.position.set(this.mCameraInfo.position).add(this.sDelta);
        if (!immediate) {
            this.sDelta.limit(180.0f * delta);
        }
        this.limitZoomChange(delta);
        this.mNextCameraInfo.clampPositionToTrack(this.mWorld.getTrack());
        this.applyChanges();
    }
}

