/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.rewards.RewardManager;
import com.agateau.ui.TextureRegionItemRendererAdapter;
import com.agateau.ui.menu.GridMenuItem;
import com.agateau.ui.menu.Menu;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

public class ChampionshipSelector
extends GridMenuItem<Championship> {
    private Assets mAssets;
    private RewardManager mRewardManager;

    public ChampionshipSelector(Menu menu) {
        super(menu);
    }

    public void init(Assets assets, RewardManager rewardManager) {
        this.mAssets = assets;
        this.mRewardManager = rewardManager;
        this.setItemSize(160.0f, 160.0f);
        this.setItemRenderer(new Renderer());
        this.setItems(this.mAssets.championships);
    }

    private class Renderer
    extends TextureRegionItemRendererAdapter<Championship> {
        private Renderer() {
        }

        @Override
        protected TextureRegion getItemRegion(Championship championship) {
            return this.isItemEnabled(championship) ? ChampionshipSelector.this.mAssets.getChampionshipRegion(championship) : ChampionshipSelector.this.mAssets.getLockedTrackRegion();
        }

        @Override
        public boolean isItemEnabled(Championship championship) {
            return ChampionshipSelector.this.mRewardManager.isChampionshipUnlocked(championship);
        }
    }
}

