/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.ui.UiAssets;
import com.agateau.ui.UiInputActor;
import com.agateau.ui.VirtualKey;
import com.agateau.utils.Assert;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

public class NavStageScreen
extends PwStageScreen {
    private NavListener mNavListener;

    public NavStageScreen(UiAssets uiAssets) {
        super(uiAssets);
        this.getStage().addActor(new UiInputActor(){

            @Override
            public void onKeyJustPressed(VirtualKey key) {
                if (key == VirtualKey.TRIGGER) {
                    NavStageScreen.this.onNextPressed();
                }
            }
        });
    }

    public void setNavListener(NavListener navListener) {
        this.mNavListener = navListener;
    }

    public void setupNextButton(Button button) {
        button.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                NavStageScreen.this.onNextPressed();
            }
        });
    }

    @Override
    public void onBackPressed() {
        Assert.check(this.mNavListener != null, "No listener set", new Object[0]);
        this.mNavListener.onBackPressed();
    }

    public void onNextPressed() {
        Assert.check(this.mNavListener != null, "No listener set", new Object[0]);
        this.mNavListener.onNextPressed();
    }

    public static interface NavListener {
        public void onBackPressed();

        public void onNextPressed();
    }

    public static abstract class NextListener
    implements NavListener {
        @Override
        public void onBackPressed() {
            this.onNextPressed();
        }
    }
}

