/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.gameinput.EnoughInputsChecker;
import com.agateau.pixelwheels.gamesetup.Maestro;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.pixelwheels.utils.StringUtils;
import com.agateau.translations.Translator;
import com.agateau.ui.ScreenStack;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItemListener;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.utils.Array;

public class NotEnoughInputsScreen
extends PwStageScreen {
    private final PwGame mGame;
    private final Maestro mMaestro;
    private final EnoughInputsChecker mEnoughInputsChecker;
    private Label mLabel;
    private static final StringBuilder sStringBuilder = new StringBuilder();

    public NotEnoughInputsScreen(PwGame game, Maestro maestro, EnoughInputsChecker checker) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.mMaestro = maestro;
        this.mEnoughInputsChecker = checker;
        this.setupUi();
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                ScreenStack stack = NotEnoughInputsScreen.this.mGame.getScreenStack();
                stack.hideBlockingScreen();
                stack.showBlockingScreen(new NotEnoughInputsScreen(NotEnoughInputsScreen.this.mGame, NotEnoughInputsScreen.this.mMaestro, NotEnoughInputsScreen.this.mEnoughInputsChecker));
            }
        };
        this.updateMissingInputs();
    }

    @Override
    public void onBackPressed() {
    }

    public void updateMissingInputs() {
        sStringBuilder.setLength(0);
        Array<String> inputNames = this.mEnoughInputsChecker.getInputNames();
        for (int playerId = 0; playerId < this.mEnoughInputsChecker.getInputCount(); ++playerId) {
            String name;
            if (playerId > 0) {
                sStringBuilder.append("\n");
            }
            String status = (name = inputNames.get(playerId)) == null ? StringUtils.missingInputHandlerMessage() : name;
            sStringBuilder.append(StringUtils.format(Translator.tr("Player #%d: %s"), playerId + 1, status));
        }
        this.mLabel.setText(sStringBuilder.toString());
        this.mLabel.setSize(this.mLabel.getPrefWidth(), this.mLabel.getPrefHeight());
    }

    private void setupUi() {
        Assets assets = this.mGame.getAssets();
        UiBuilder builder = new UiBuilder(assets.atlas, assets.ui.skin);
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/notenoughgamepads.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        this.mLabel = (Label)builder.getActor("gamepadsLabel");
        Menu menu = (Menu)builder.getActor("menu");
        menu.addButton(Translator.tr("MAIN MENU")).addListener(new MenuItemListener(){

            @Override
            public void triggered() {
                NotEnoughInputsScreen.this.mMaestro.stopEnoughInputChecker();
                NotEnoughInputsScreen.this.mGame.showMainMenu();
            }
        });
    }
}

