/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.utils.DrawUtils;
import com.agateau.utils.AgcMathUtils;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.TiledDrawable;

class ScrollableTiledImage
extends Actor {
    private final float mPixelsPerSecond;
    private final TiledDrawable mDrawable;
    private FrameBuffer mFrameBuffer;
    private float mOffset = 0.0f;

    ScrollableTiledImage(TextureRegion region, float pixelsPerSecond) {
        this.mDrawable = new TiledDrawable(region);
        this.mPixelsPerSecond = pixelsPerSecond;
    }

    @Override
    protected void sizeChanged() {
        super.sizeChanged();
        this.ensureFrameBufferOK();
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        float tileHeight = this.mDrawable.getMinHeight();
        this.mOffset = AgcMathUtils.modulo(this.mOffset + delta * this.mPixelsPerSecond, tileHeight);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        DrawUtils.multiplyBatchAlphaBy(batch, parentAlpha);
        batch.draw((Texture)this.mFrameBuffer.getColorBufferTexture(), this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 1.0f, 1.0f, 0.0f, 0, (int)this.mOffset, (int)this.getWidth(), (int)this.getHeight(), false, true);
    }

    private void ensureFrameBufferOK() {
        int width = (int)(this.getWidth() + this.mDrawable.getMinWidth());
        int height = (int)(this.getHeight() + this.mDrawable.getMinHeight());
        if (this.mFrameBuffer != null && this.mFrameBuffer.getWidth() == width && this.mFrameBuffer.getHeight() == height) {
            return;
        }
        this.mFrameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, false);
        SpriteBatch batch = new SpriteBatch();
        batch.setProjectionMatrix(new Matrix4().setToOrtho2D(0.0f, 0.0f, width, height));
        this.mFrameBuffer.begin();
        batch.begin();
        this.mDrawable.draw(batch, 0.0f, 0.0f, width, height);
        batch.end();
        this.mFrameBuffer.end();
        batch.dispose();
    }
}

