/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.Language;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.screens.ConfigScreen;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.GridMenuItem;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.CollectionUtils;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import java.util.HashMap;
import java.util.Map;

public class SelectLanguageScreen
extends PwStageScreen {
    private static final int FONT_SIZE = 24;
    private static final float ITEM_HEIGHT = 40.0f;
    private final PwGame mGame;

    SelectLanguageScreen(PwGame game) {
        super(game.getAssets().ui);
        this.mGame = game;
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                SelectLanguageScreen.this.mGame.replaceScreen(new SelectLanguageScreen(SelectLanguageScreen.this.mGame));
            }
        };
        this.setupUi();
    }

    private void setupUi() {
        UiBuilder builder = new UiBuilder(this.mGame.getAssets().atlas, this.mGame.getAssets().ui.skin);
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/selectlanguage.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        Menu menu = (Menu)builder.getActor("menu");
        GridMenuItem<Language> languageSelector = this.createLanguageSelector(menu);
        menu.addItem(languageSelector);
        menu.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SelectLanguageScreen.this.onBackPressed();
            }
        });
    }

    private GridMenuItem<Language> createLanguageSelector(Menu menu) {
        final GridMenuItem<Language> languageSelector = new GridMenuItem<Language>(menu);
        Array<Language> languages = this.mGame.getAssets().languages.getAll();
        languages.sort((l1, l2) -> l1.name.compareToIgnoreCase(l2.name));
        languageSelector.setItemDirection(GridMenuItem.ItemDirection.TopToBottom);
        languageSelector.setItems(languages);
        languageSelector.setItemSize(menu.getWidth() / 2.0f - 10.0f, 40.0f);
        languageSelector.setColumnCount(2);
        languageSelector.setTouchUiConfirmMode(GridMenuItem.TouchUiConfirmMode.SINGLE_TOUCH);
        HashMap<String, BitmapFont> fontForLanguage = SelectLanguageScreen.getFontForLanguage(languages);
        languageSelector.setItemRenderer(new LanguageSelectorRenderer(fontForLanguage));
        for (Language language : languages) {
            if (!language.id.equals(this.mGame.getConfig().languageId)) continue;
            languageSelector.setCurrent(language);
        }
        languageSelector.setSelectionListener(new GridMenuItem.SelectionListener<Language>(){

            @Override
            public void currentChanged(Language item, int index) {
            }

            @Override
            public void selectionConfirmed() {
                SelectLanguageScreen.this.selectLanguage(((Language)languageSelector.getSelected()).id);
            }
        });
        return languageSelector;
    }

    private static HashMap<String, BitmapFont> getFontForLanguage(Array<Language> languages) {
        HashMap<String, String> alphabetForFontName = new HashMap<String, String>();
        for (Language language : languages) {
            String string = language.fontSet.defaultFontName;
            String alphabet = CollectionUtils.getOrDefault(alphabetForFontName, string, "");
            alphabet = alphabet + language.name;
            alphabetForFontName.put(string, alphabet);
        }
        HashMap<String, BitmapFont> fontForFontName = new HashMap<String, BitmapFont>();
        for (Map.Entry entry : alphabetForFontName.entrySet()) {
            String fontName = (String)entry.getKey();
            String alphabet = (String)entry.getValue();
            FreeTypeFontGenerator generator = new FreeTypeFontGenerator(FileUtils.assets("fonts/" + fontName));
            FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
            parameter.characters = alphabet;
            parameter.size = 24;
            BitmapFont font = generator.generateFont(parameter);
            generator.dispose();
            fontForFontName.put(fontName, font);
        }
        HashMap<String, BitmapFont> hashMap = new HashMap<String, BitmapFont>();
        for (Language language : languages) {
            hashMap.put(language.id, (BitmapFont)fontForFontName.get(language.fontSet.defaultFontName));
        }
        return hashMap;
    }

    private void selectLanguage(String languageId) {
        this.getStage().getRoot().addAction(Actions.sequence((Action)Actions.alpha(0.3f, 0.1f, Interpolation.pow2Out), (Action)Actions.run(() -> this.doSelectLanguage(languageId))));
    }

    private void doSelectLanguage(String languageId) {
        this.mGame.getConfig().languageId = languageId;
        this.mGame.getConfig().flush(GameConfig.ConfigGroup.LANGUAGE);
        ConfigScreen screen = ConfigScreen.createAfterLanguageChange(this.mGame);
        this.mGame.popScreen();
        this.mGame.replaceScreen(screen);
    }

    @Override
    public void onBackPressed() {
        this.mGame.popScreen();
    }

    private static class LanguageSelectorRenderer
    implements GridMenuItem.ItemRenderer<Language> {
        private final HashMap<String, BitmapFont> mFontForLanguage;
        private final Rectangle mRectangle = new Rectangle();

        public LanguageSelectorRenderer(HashMap<String, BitmapFont> fontForLanguage) {
            this.mFontForLanguage = fontForLanguage;
        }

        @Override
        public Rectangle getItemRectangle(float width, float height, Language item) {
            this.mRectangle.set(0.0f, 0.0f, width, height);
            return this.mRectangle;
        }

        @Override
        public void render(Batch batch, float x, float y, float width, float height, Language item) {
            BitmapFont font = this.mFontForLanguage.get(item.id);
            font.setColor(batch.getColor());
            font.draw(batch, item.name, x, y += height - (height - font.getCapHeight()) / 2.0f, width, 1, false);
        }

        @Override
        public boolean isItemEnabled(Language item) {
            return true;
        }
    }
}

