/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.screens.ChampionshipSelector;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.pixelwheels.screens.TrackSelector;
import com.agateau.pixelwheels.stats.TrackResult;
import com.agateau.pixelwheels.stats.TrackStats;
import com.agateau.pixelwheels.utils.StringUtils;
import com.agateau.pixelwheels.utils.UiUtils;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.translations.Translator;
import com.agateau.ui.TableRowCreator;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.CornerMenuButton;
import com.agateau.ui.menu.GridMenuItem;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItemListener;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import java.util.ArrayList;

public class SelectTrackScreen
extends PwStageScreen {
    private final PwGame mGame;
    private final Listener mListener;
    private ChampionshipSelector mChampionshipSelector;
    private TrackSelector mTrackSelector;
    private Label mTrackNameLabel;
    private Label mUnlockHintLabel;
    private Label mLapRecordsLabel;
    private Table mLapRecordsTable;
    private Label mTotalRecordsLabel;
    private Table mTotalRecordsTable;
    private AnchorGroup root;
    private final TableRowCreator mTableRowCreator = new TableRowCreator(RecordTableColumn.values().length){

        @Override
        protected Cell createCell(Table table, int columnIdx, String value, String style) {
            RecordTableColumn column = RecordTableColumn.values()[columnIdx];
            Cell<Widget> cell = null;
            switch (column) {
                case RANK: {
                    cell = table.add(this.createBestIndicatorImage(value));
                    cell.right();
                    break;
                }
                case RACER: {
                    cell = table.add(value, style);
                    cell.left().growX();
                    break;
                }
                case TIME: {
                    cell = table.add(value, style);
                    cell.right();
                }
            }
            return cell;
        }

        private Image createBestIndicatorImage(String idx) {
            TextureAtlas.AtlasRegion region = ((SelectTrackScreen)SelectTrackScreen.this).mGame.getAssets().ui.atlas.findRegion("best-" + idx + "-small");
            Image image = new Image(region);
            image.pack();
            return image;
        }
    };
    private CornerMenuButton mNextButton;

    public SelectTrackScreen(PwGame game, Listener listener) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.mListener = listener;
        this.mTableRowCreator.setRowStyle("small");
        this.mTableRowCreator.setSpacing(12);
        this.setupUi();
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                SelectTrackScreen.this.mGame.replaceScreen(new SelectTrackScreen(SelectTrackScreen.this.mGame, SelectTrackScreen.this.mListener));
            }
        };
    }

    private void setupUi() {
        UiBuilder builder = UiUtils.createUiBuilder(this.mGame.getAssets());
        this.root = (AnchorGroup)builder.build(FileUtils.assets("screens/selecttrack.gdxui"));
        this.root.setFillParent(true);
        this.getStage().addActor(this.root);
        this.mTrackNameLabel = (Label)builder.getActor("trackNameLabel");
        this.mUnlockHintLabel = (Label)builder.getActor("unlockHintLabel");
        this.mLapRecordsLabel = (Label)builder.getActor("lapRecordsLabel");
        this.mLapRecordsTable = (Table)builder.getActor("lapRecordsTable");
        this.mTotalRecordsLabel = (Label)builder.getActor("totalRecordsLabel");
        this.mTotalRecordsTable = (Table)builder.getActor("totalRecordsTable");
        Menu menu = (Menu)builder.getActor("menu");
        Track track = this.getCurrentTrack();
        this.createChampionshipSelector(menu, track);
        this.createTrackSelector(menu, track);
        this.updateTrackDetails(track);
        menu.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SelectTrackScreen.this.onBackPressed();
            }
        });
        this.mNextButton = menu.addNextButton();
        this.mNextButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SelectTrackScreen.this.next();
            }
        });
        this.updateNextButton();
    }

    private void updateNextButton() {
        this.mNextButton.setDisabled(!this.mTrackSelector.isCurrentItemEnabled());
    }

    private Track getCurrentTrack() {
        Assets assets = this.mGame.getAssets();
        Track track = assets.findTrackById(this.mGame.getConfig().track);
        if (track == null) {
            track = assets.championships.get(0).getTracks().get(0);
        }
        return track;
    }

    private void createChampionshipSelector(final Menu menu, Track currentTrack) {
        Assets assets = this.mGame.getAssets();
        this.mChampionshipSelector = new ChampionshipSelector(menu);
        this.mChampionshipSelector.setMenuStyle(menu.getMenuStyleByName("large"));
        this.mChampionshipSelector.setColumnCount(3);
        this.mChampionshipSelector.init(assets, this.mGame.getRewardManager());
        this.mChampionshipSelector.setSelected(currentTrack.getChampionship());
        menu.addItem(this.mChampionshipSelector);
        this.mChampionshipSelector.setSelectionListener(new GridMenuItem.SelectionListener<Championship>(){

            @Override
            public void currentChanged(Championship item, int index) {
                SelectTrackScreen.this.mChampionshipSelector.setSelected(item);
                SelectTrackScreen.this.mTrackSelector.setCurrentChampionship(item);
                SelectTrackScreen.this.mTrackSelector.setSelected(null);
                SelectTrackScreen.this.updateTrackDetails((Track)SelectTrackScreen.this.mTrackSelector.getCurrent());
                SelectTrackScreen.this.updateNextButton();
            }

            @Override
            public void selectionConfirmed() {
            }
        });
        this.mChampionshipSelector.setListener(new MenuItemListener(){

            @Override
            public void triggered() {
                menu.setCurrentItem(SelectTrackScreen.this.mTrackSelector);
            }
        });
    }

    private void createTrackSelector(Menu menu, Track currentTrack) {
        Assets assets = this.mGame.getAssets();
        this.mTrackSelector = new TrackSelector(menu);
        this.mTrackSelector.setMenuStyle(menu.getMenuStyleByName("large"));
        this.mTrackSelector.setColumnCount(3);
        this.mTrackSelector.init(assets, this.mGame.getRewardManager(), currentTrack.getChampionship());
        this.mTrackSelector.setCurrent(currentTrack);
        menu.addItem(this.mTrackSelector);
        this.mTrackSelector.setSelectionListener(new GridMenuItem.SelectionListener<Track>(){

            @Override
            public void currentChanged(Track track, int index) {
                SelectTrackScreen.this.updateTrackDetails(track);
                SelectTrackScreen.this.updateNextButton();
            }

            @Override
            public void selectionConfirmed() {
                SelectTrackScreen.this.next();
            }
        });
    }

    @Override
    public void onBackPressed() {
        this.mListener.onBackPressed();
    }

    private void saveSelectedMap() {
        this.mGame.getConfig().track = ((Track)this.mTrackSelector.getCurrent()).getId();
        this.mGame.getConfig().flush(GameConfig.ConfigGroup.OTHER);
    }

    private void next() {
        if (!this.mTrackSelector.isCurrentItemEnabled()) {
            return;
        }
        this.saveSelectedMap();
        this.mListener.onTrackSelected((Track)this.mTrackSelector.getCurrent());
    }

    private void updateTrackDetails(Track track) {
        if (this.mGame.getRewardManager().isTrackUnlocked(track)) {
            this.updateUnlockedTrackDetails(track);
        } else {
            this.updateLockedTrackDetails(track);
        }
        this.root.layout();
    }

    private void updateLockedTrackDetails(Track track) {
        this.mTrackNameLabel.setText(Translator.tr("[Locked]"));
        this.mUnlockHintLabel.setVisible(true);
        this.mUnlockHintLabel.setText(this.mGame.getRewardManager().getUnlockText(track));
        this.mLapRecordsLabel.setVisible(false);
        this.mTotalRecordsLabel.setVisible(false);
        this.mLapRecordsTable.clearChildren();
        this.mTotalRecordsTable.clearChildren();
    }

    private void updateUnlockedTrackDetails(Track track) {
        this.mTrackNameLabel.setText(track.getMapName());
        this.mTrackNameLabel.pack();
        this.mUnlockHintLabel.setVisible(false);
        this.mLapRecordsLabel.setVisible(true);
        this.mTotalRecordsLabel.setVisible(true);
        this.updateRecordLabel(this.mLapRecordsTable, track, TrackStats.ResultType.LAP);
        this.updateRecordLabel(this.mTotalRecordsTable, track, TrackStats.ResultType.TOTAL);
    }

    private void updateRecordLabel(Table table, Track track, TrackStats.ResultType resultType) {
        TrackStats stats = this.mGame.getGameStats().getTrackStats(this.mGame.getConfig().difficulty, track);
        ArrayList<TrackResult> records = stats.get(resultType);
        table.clearChildren();
        this.mTableRowCreator.setTable(table);
        int n = records.size();
        for (int idx = 0; idx < n; ++idx) {
            TrackResult record = records.get(idx);
            this.mTableRowCreator.addRow(String.valueOf(idx + 1), this.getVehicleName(record.vehicle), StringUtils.formatRaceTime(record.value));
        }
        table.setHeight(table.getPrefHeight());
    }

    private String getVehicleName(String vehicleId) {
        if (vehicleId.equals("CPU")) {
            return Translator.trc("CPU", "vehicle-record-placeholder");
        }
        VehicleDef vehicleDef = this.mGame.getAssets().findVehicleDefById(vehicleId);
        return vehicleDef == null ? vehicleId : vehicleDef.getName();
    }

    public static interface Listener {
        public void onBackPressed();

        public void onTrackSelected(Track var1);
    }

    static enum RecordTableColumn {
        RANK,
        RACER,
        TIME;

    }
}

