/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.screens.VehicleDrawer;
import com.agateau.pixelwheels.utils.DrawUtils;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.ui.uibuilder.UiBuilder;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;

class VehicleActor
extends Actor {
    private final VehicleDrawer mDrawer;

    private VehicleActor(Assets assets) {
        this.mDrawer = new VehicleDrawer(assets);
    }

    static void register(UiBuilder builder, Assets assets) {
        builder.registerActorFactory("Vehicle", (uiBuilder, element) -> new VehicleActor(assets));
    }

    public void setVehicleDef(VehicleDef vehicleDef) {
        this.mDrawer.setVehicleDef(vehicleDef);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        DrawUtils.multiplyBatchAlphaBy(batch, parentAlpha);
        this.mDrawer.setCenter(this.getX(), this.getY());
        this.mDrawer.setAngle(90.0f + this.getRotation());
        this.mDrawer.draw(batch);
    }
}

