/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens.config;

import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.gameinput.GameInputHandler;
import com.agateau.pixelwheels.gameinput.KeyboardInputHandler;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.pixelwheels.screens.config.ConfigUiUtils;
import com.agateau.translations.Translator;
import com.agateau.ui.KeyMapper;
import com.agateau.ui.UiInputMapper;
import com.agateau.ui.VirtualKey;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.ButtonMenuItem;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItemListener;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.Assert;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import java.util.HashMap;

public class KeyboardConfigScreen
extends PwStageScreen {
    private final PwGame mGame;
    private final int mPlayerIdx;
    private final Array<KeyMapper> mKeyMappers = new Array();
    private final HashMap<VirtualKey, ButtonMenuItem> mKeyButtonMap = new HashMap();
    private KeyMapper mKeyMapper;
    private Menu mMenu;
    private VirtualKey mEditedVirtualKey;
    private final InputListener mEditListener = new InputListener(){

        @Override
        public boolean keyUp(InputEvent event, int keycode) {
            Assert.check(KeyboardConfigScreen.this.mEditedVirtualKey != null, "mEditVirtualKey should be set", new Object[0]);
            if (keycode != 111) {
                KeyboardConfigScreen.this.updateKey(keycode);
            }
            KeyboardConfigScreen.this.updateButtonText(KeyboardConfigScreen.this.mEditedVirtualKey);
            KeyboardConfigScreen.this.stopEditing();
            return true;
        }
    };

    KeyboardConfigScreen(PwGame game, int playerIdx) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.mPlayerIdx = playerIdx;
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                KeyboardConfigScreen.this.mGame.replaceScreen(new KeyboardConfigScreen(KeyboardConfigScreen.this.mGame, KeyboardConfigScreen.this.mPlayerIdx));
            }
        };
        for (int idx = 0; idx < 4; ++idx) {
            GameInputHandler handler = this.mGame.getConfig().getPlayerInputHandler(idx);
            if (!(handler instanceof KeyboardInputHandler)) continue;
            KeyboardInputHandler keyboardInputHandler = (KeyboardInputHandler)handler;
            KeyMapper mapper = keyboardInputHandler.getKeyMapper();
            this.mKeyMappers.add(mapper);
            if (idx != playerIdx) continue;
            this.mKeyMapper = mapper;
        }
        Assert.check(this.mKeyMapper != null, "no key mapper found for player " + playerIdx, new Object[0]);
        this.setupUi();
    }

    private void setupUi() {
        UiBuilder builder = new UiBuilder(this.mGame.getAssets().atlas, this.mGame.getAssets().ui.skin);
        if (this.mPlayerIdx == 0) {
            builder.defineVariable("player1");
        }
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/keyboardconfig.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        this.mMenu = (Menu)builder.getActor("menu");
        if (this.mPlayerIdx == 0) {
            this.createKeyItem(this.mMenu, Translator.tr("Brake"), VirtualKey.DOWN);
            this.createKeyItem(this.mMenu, Translator.tr("Steer left"), VirtualKey.LEFT);
            this.createKeyItem(this.mMenu, Translator.tr("Steer right"), VirtualKey.RIGHT);
            this.createKeyItem(this.mMenu, Translator.tr("Trigger"), VirtualKey.TRIGGER);
            this.createKeyItem(this.mMenu, Translator.tr("Screenshot"), VirtualKey.SCREENSHOT);
        } else {
            ConfigUiUtils.createTwoColumnTitle(this.mMenu, Translator.tr("Menu"), Translator.tr("Game"));
            this.createKeyItem(this.mMenu, Translator.tr("Up"), "-", VirtualKey.UP);
            this.createKeyItem(this.mMenu, Translator.tr("Down"), Translator.tr("Brake"), VirtualKey.DOWN);
            this.createKeyItem(this.mMenu, Translator.tr("Left"), Translator.tr("Steer left"), VirtualKey.LEFT);
            this.createKeyItem(this.mMenu, Translator.tr("Right"), Translator.tr("Steer right"), VirtualKey.RIGHT);
            this.createKeyItem(this.mMenu, Translator.tr("Activate"), Translator.tr("Trigger"), VirtualKey.TRIGGER);
            this.createKeyItem(this.mMenu, Translator.tr("Back"), "-", VirtualKey.BACK);
        }
        this.mMenu.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                KeyboardConfigScreen.this.onBackPressed();
            }
        });
    }

    private void createKeyItem(Menu menu, String text1, String text2, final VirtualKey virtualKey) {
        final ButtonMenuItem button = new ButtonMenuItem(menu, this.getButtonText(virtualKey));
        ConfigUiUtils.createTwoColumnRow(menu, text1, text2, button);
        button.addListener(new MenuItemListener(){

            @Override
            public void triggered() {
                KeyboardConfigScreen.this.startEditing(button, virtualKey);
            }
        });
        this.mKeyButtonMap.put(virtualKey, button);
    }

    private void createKeyItem(Menu menu, String text, VirtualKey virtualKey) {
        this.createKeyItem(menu, text, null, virtualKey);
    }

    private void updateKey(int newKey) {
        KeyMapper keyMapper = this.getKeyMapper(this.mEditedVirtualKey);
        int oldKey = keyMapper.getKey(this.mEditedVirtualKey);
        keyMapper.setKey(this.mEditedVirtualKey, newKey);
        this.checkConflicts(oldKey, newKey);
    }

    private KeyMapper getKeyMapper(VirtualKey virtualKey) {
        KeyMapper uiKeyMapper = UiInputMapper.getInstance().getKeyMapper();
        return virtualKey == VirtualKey.SCREENSHOT ? uiKeyMapper : this.mKeyMapper;
    }

    private void checkConflicts(int oldKey, int newKey) {
        for (KeyMapper keyMapper : this.mKeyMappers) {
            for (VirtualKey virtualKey : VirtualKey.values()) {
                int key;
                if (keyMapper == this.mKeyMapper && virtualKey == this.mEditedVirtualKey || (key = keyMapper.getKey(virtualKey)) != newKey) continue;
                keyMapper.setKey(virtualKey, oldKey);
                if (keyMapper != this.mKeyMapper) continue;
                this.updateButtonText(virtualKey);
            }
        }
    }

    private void startEditing(ButtonMenuItem button, VirtualKey virtualKey) {
        this.mMenu.setDisabled(true);
        this.mEditedVirtualKey = virtualKey;
        button.setText("...");
        this.getStage().getRoot().addListener(this.mEditListener);
    }

    private void stopEditing() {
        this.mMenu.setDisabled(false);
        this.getStage().getRoot().removeListener(this.mEditListener);
        this.mEditedVirtualKey = null;
    }

    private void updateButtonText(VirtualKey key) {
        ButtonMenuItem button = this.mKeyButtonMap.get((Object)key);
        if (button == null) {
            return;
        }
        button.setText(this.getButtonText(key));
    }

    private String getButtonText(VirtualKey virtualKey) {
        int key = this.getKeyMapper(virtualKey).getKey(virtualKey);
        return Input.Keys.toString(key);
    }

    @Override
    public void onBackPressed() {
        this.saveConfig();
        this.mGame.popScreen();
    }

    private void saveConfig() {
        GameConfig config = this.mGame.getConfig();
        config.savePlayerInputHandlerConfig(this.mPlayerIdx);
    }
}

