/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.sound;

import com.agateau.pixelwheels.sound.SoundPlayer;
import com.agateau.pixelwheels.sound.SoundThreadManager;
import com.badlogic.gdx.audio.Sound;

public class DefaultSoundPlayer
implements SoundPlayer {
    private final SoundThreadManager mSoundThreadManager;
    private final Sound mSound;
    private long mId = -1L;
    private boolean mLooping = false;
    private float mVolume = 1.0f;
    private float mPitch = 1.0f;
    private boolean mMuted = false;

    public DefaultSoundPlayer(SoundThreadManager soundThreadManager, Sound sound) {
        this.mSoundThreadManager = soundThreadManager;
        this.mSound = sound;
    }

    @Override
    public void play() {
        if (this.mMuted) {
            return;
        }
        this.stop();
        this.mId = this.mSoundThreadManager.play(this.mSound, this.mVolume, this.mPitch);
    }

    @Override
    public void loop() {
        if (this.mMuted) {
            return;
        }
        this.stop();
        this.mId = this.mSoundThreadManager.loop(this.mSound, this.mVolume, this.mPitch);
        this.mLooping = true;
    }

    @Override
    public void stop() {
        if (this.mId == -1L) {
            return;
        }
        this.mSoundThreadManager.stop(this.mId);
        this.mId = -1L;
        this.mLooping = false;
    }

    @Override
    public float getVolume() {
        return this.mVolume;
    }

    @Override
    public void setVolume(float volume) {
        this.mVolume = volume;
        this.updateVolume();
    }

    @Override
    public float getPitch() {
        return this.mPitch;
    }

    @Override
    public void setPitch(float pitch) {
        this.mPitch = pitch;
        if (this.mId != -1L) {
            this.mSoundThreadManager.setPitch(this.mId, this.mPitch);
        }
    }

    @Override
    public boolean isLooping() {
        return this.mLooping;
    }

    void setMuted(boolean muted) {
        this.mMuted = muted;
        this.updateVolume();
        if (this.mMuted) {
            this.stop();
        }
    }

    private void updateVolume() {
        if (this.mId != -1L) {
            this.mSoundThreadManager.setVolume(this.mId, this.mMuted ? 0.0f : this.mVolume);
        }
    }
}

