/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.utils;

import com.agateau.pixelwheels.map.MapUtils;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.objects.EllipseMapObject;
import com.badlogic.gdx.maps.objects.PolygonMapObject;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Ellipse;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.World;
import java.util.Arrays;

public class Box2DUtils {
    public static final float MS_TO_KMH = 3.6f;
    private static final Vector2 FORWARD_VECTOR = new Vector2(1.0f, 0.0f);
    private static final Vector2 LATERAL_VECTOR = new Vector2(0.0f, 1.0f);
    private static final Vector2 sTmp = new Vector2();

    public static Vector2 getForwardVelocity(Body body) {
        Vector2 currentRightNormal = body.getWorldVector(FORWARD_VECTOR);
        float v = currentRightNormal.dot(body.getLinearVelocity());
        return currentRightNormal.scl(v);
    }

    public static Vector2 getLateralVelocity(Body body) {
        Vector2 currentRightNormal = body.getWorldVector(LATERAL_VECTOR);
        float v = currentRightNormal.dot(body.getLinearVelocity());
        return currentRightNormal.scl(v);
    }

    public static void applyDrag(Body body, float factor) {
        Vector2 dragForce = body.getLinearVelocity().scl(-factor);
        body.applyForce(dragForce, body.getWorldCenter(), true);
    }

    public static void applyCircularDrag(Body body, float factor) {
        float velocity = -body.getAngularVelocity() * factor;
        body.applyTorque(velocity, true);
    }

    public static Body createStaticBox(World world, float x, float y, float width, float height) {
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyDef.BodyType.StaticBody;
        bodyDef.position.set(x + width / 2.0f, y + height / 2.0f);
        Body body = world.createBody(bodyDef);
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(width / 2.0f, height / 2.0f);
        body.createFixture(shape, 1.0f);
        return body;
    }

    public static void setCollisionInfo(Body body, int categoryBits, int maskBits) {
        for (Fixture fixture : body.getFixtureList()) {
            Filter filter = fixture.getFilterData();
            filter.categoryBits = (short)categoryBits;
            filter.maskBits = (short)maskBits;
            fixture.setFilterData(filter);
        }
    }

    public static Body createStaticBodyForMapObject(World world, MapObject object) {
        float u = 0.05f;
        float rotation = MapUtils.getObjectRotation(object);
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyDef.BodyType.StaticBody;
        bodyDef.angle = rotation * ((float)Math.PI / 180);
        if (object instanceof RectangleMapObject) {
            Rectangle rect = ((RectangleMapObject)object).getRectangle();
            float[] vertices = new float[]{0.0f, 0.0f, 0.0f, -rect.getHeight(), rect.getWidth(), -rect.getHeight(), rect.getWidth(), 0.0f};
            Box2DUtils.scaleVertices(vertices, 0.05f);
            bodyDef.position.set(0.05f * rect.getX(), 0.05f * (rect.getY() + rect.getHeight()));
            Body body = world.createBody(bodyDef);
            PolygonShape shape = new PolygonShape();
            shape.set(vertices);
            body.createFixture(shape, 1.0f);
            return body;
        }
        if (object instanceof PolygonMapObject) {
            Polygon polygon = ((PolygonMapObject)object).getPolygon();
            float[] vertices = (float[])polygon.getVertices().clone();
            Box2DUtils.scaleVertices(vertices, 0.05f);
            bodyDef.position.set(polygon.getX() * 0.05f, polygon.getY() * 0.05f);
            Body body = world.createBody(bodyDef);
            PolygonShape shape = new PolygonShape();
            shape.set(vertices);
            body.createFixture(shape, 1.0f);
            return body;
        }
        if (object instanceof EllipseMapObject) {
            Ellipse ellipse = ((EllipseMapObject)object).getEllipse();
            float radius = ellipse.width * 0.05f / 2.0f;
            float x = ellipse.x * 0.05f + radius;
            float y = ellipse.y * 0.05f + radius;
            bodyDef.position.set(x, y);
            Body body = world.createBody(bodyDef);
            CircleShape shape = new CircleShape();
            shape.setRadius(radius);
            body.createFixture(shape, 1.0f);
            return body;
        }
        throw new RuntimeException("Unsupported MapObject type: " + object);
    }

    public static float[] createOctogon(float width, float height, float cornerWidth, float cornerHeight) {
        return new float[]{width / 2.0f - cornerWidth, -height / 2.0f, width / 2.0f, -height / 2.0f + cornerHeight, width / 2.0f, height / 2.0f - cornerHeight, width / 2.0f - cornerWidth, height / 2.0f, -width / 2.0f + cornerWidth, height / 2.0f, -width / 2.0f, height / 2.0f - cornerHeight, -width / 2.0f, -height / 2.0f + cornerHeight, -width / 2.0f + cornerWidth, -height / 2.0f};
    }

    public static Shape createBox2DShape(Shape2D shape2D, float zoomFactor) {
        if (shape2D instanceof Polygon) {
            float[] polygonVertices = ((Polygon)shape2D).getTransformedVertices();
            PolygonShape shape = new PolygonShape();
            float[] vertices = Arrays.copyOf(polygonVertices, polygonVertices.length);
            Box2DUtils.scaleVertices(vertices, zoomFactor);
            shape.set(vertices);
            return shape;
        }
        if (shape2D instanceof Circle) {
            Circle circleShape2D = (Circle)shape2D;
            CircleShape shape = new CircleShape();
            sTmp.set(circleShape2D.x, circleShape2D.y).scl(zoomFactor);
            shape.setPosition(sTmp);
            shape.setRadius(circleShape2D.radius * zoomFactor);
            return shape;
        }
        if (shape2D instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape2D;
            float[] vertices = new float[8];
            float x1 = rectangle.x;
            float y1 = rectangle.y;
            float x2 = x1 + rectangle.width;
            float y2 = y1 + rectangle.height;
            Box2DUtils.setVertice(vertices, 0, x1, y1);
            Box2DUtils.setVertice(vertices, 2, x2, y1);
            Box2DUtils.setVertice(vertices, 4, x2, y2);
            Box2DUtils.setVertice(vertices, 6, x1, y2);
            Box2DUtils.scaleVertices(vertices, zoomFactor);
            PolygonShape shape = new PolygonShape();
            shape.set(vertices);
            return shape;
        }
        throw new RuntimeException("Unsupported Shape2D type " + shape2D);
    }

    private static void scaleVertices(float[] vertices, float factor) {
        int idx = 0;
        while (idx < vertices.length) {
            int n = idx++;
            vertices[n] = vertices[n] * factor;
        }
    }

    private static void setVertice(float[] vertices, int idx, float x, float y) {
        vertices[idx] = x;
        vertices[idx + 1] = y;
    }
}

