/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.agateau.ui.GamepadInputMapper;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerAdapter;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DelayedRemovalArray;

public class GamepadInputMappers {
    public static final int MAX_GAMEPAD_COUNT = 4;
    private final GamepadInputMapper[] mMappers = new GamepadInputMapper[4];
    private final DelayedRemovalArray<Listener> mListeners = new DelayedRemovalArray(0);
    private static GamepadInputMappers sInstance;

    public static GamepadInputMappers getInstance() {
        if (sInstance == null) {
            sInstance = new GamepadInputMappers();
        }
        return sInstance;
    }

    public GamepadInputMapper[] getMappers() {
        return this.mMappers;
    }

    public void addListener(Listener listener) {
        if (!this.mListeners.contains(listener, true)) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.mListeners.removeValue(listener, true);
    }

    private GamepadInputMappers() {
        Array<Controller> controllers = Controllers.getControllers();
        for (int idx = 0; idx < this.mMappers.length; ++idx) {
            Controller controller;
            Controller controller2 = controller = idx < controllers.size ? controllers.get(idx) : null;
            if (controller != null) {
                NLog.i("Found controller %s (%s)", controller.getUniqueId(), controller.getName());
            }
            this.mMappers[idx] = new GamepadInputMapper(controller);
        }
        Controllers.addListener(new ControllerAdapter(){

            @Override
            public void connected(Controller controller) {
                NLog.i("Controller %s connected (%s)", controller.getUniqueId(), controller.getName());
                for (GamepadInputMapper mapper : GamepadInputMappers.this.mMappers) {
                    if (mapper.getController() != null) continue;
                    mapper.setController(controller);
                    break;
                }
                GamepadInputMappers.this.mListeners.begin();
                for (Listener listener : GamepadInputMappers.this.mListeners) {
                    listener.onGamepadConnected();
                }
                GamepadInputMappers.this.mListeners.end();
            }

            @Override
            public void disconnected(Controller controller) {
                NLog.i("Controller %s disconnected", controller.getUniqueId());
                for (GamepadInputMapper mapper : GamepadInputMappers.this.mMappers) {
                    if (mapper.getController() != controller) continue;
                    mapper.setController(null);
                    break;
                }
                GamepadInputMappers.this.mListeners.begin();
                for (Listener listener : GamepadInputMappers.this.mListeners) {
                    listener.onGamepadDisconnected();
                }
                GamepadInputMappers.this.mListeners.end();
            }
        });
    }

    public static interface Listener {
        public void onGamepadConnected();

        public void onGamepadDisconnected();
    }
}

