/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.agateau.utils.Assert;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.Game;
import com.badlogic.gdx.Screen;
import java.util.Stack;

public class ScreenStack {
    private final Game mGame;
    private final Stack<Screen> mStack = new Stack();
    private Screen mBlockingScreen;

    public ScreenStack(Game game) {
        this.mGame = game;
    }

    public void push(Screen screen) {
        this.mStack.push(screen);
        this.setScreen(screen);
    }

    public void pop() {
        Assert.check(!this.mStack.isEmpty(), "mScreenStack is empty", new Object[0]);
        this.mStack.pop().dispose();
        Assert.check(!this.mStack.isEmpty(), "mScreenStack is empty", new Object[0]);
        this.setScreen(this.mStack.peek());
    }

    public void replace(Screen screen) {
        if (!this.mStack.isEmpty()) {
            this.mStack.pop().dispose();
        }
        this.push(screen);
    }

    public void clear() {
        while (!this.mStack.isEmpty()) {
            this.mStack.pop().dispose();
        }
    }

    public void showBlockingScreen(Screen screen) {
        Assert.check(this.mBlockingScreen == null, "There is already a blocking screen", new Object[0]);
        this.mBlockingScreen = screen;
        this.mGame.setScreen(this.mBlockingScreen);
    }

    public void hideBlockingScreen() {
        Assert.check(this.mBlockingScreen != null, "There is no blocking screen", new Object[0]);
        this.mBlockingScreen.dispose();
        this.mBlockingScreen = null;
        this.mGame.setScreen(this.mStack.peek());
    }

    private void setScreen(Screen screen) {
        if (this.mBlockingScreen == null) {
            NLog.i("screen=%s", screen.getClass().getSimpleName());
            this.mGame.setScreen(screen);
        }
    }
}

