/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.animscript;

import com.agateau.ui.DimensionParser;
import com.agateau.ui.animscript.AnimScriptLoader;
import com.agateau.ui.animscript.ArgumentDefinition;
import java.io.IOException;
import java.io.StreamTokenizer;

class FloatArgumentDefinition
extends ArgumentDefinition<Float> {
    private final Domain mDomain;

    FloatArgumentDefinition(Domain domain) {
        super(Float.TYPE, null);
        this.mDomain = domain;
    }

    FloatArgumentDefinition(Domain domain, float defaultValue) {
        super(Float.TYPE, Float.valueOf(defaultValue));
        this.mDomain = domain;
    }

    @Override
    public Object parse(StreamTokenizer tokenizer, DimensionParser dimParser) throws AnimScriptLoader.SyntaxException {
        float value;
        try {
            tokenizer.nextToken();
        }
        catch (IOException e) {
            throw new AnimScriptLoader.SyntaxException(tokenizer, "Missing token for argument");
        }
        if (tokenizer.ttype == -3) {
            value = this.mDomain == Domain.DIMENSION ? dimParser.parse(tokenizer.sval, DimensionParser.Unit.PIXEL) : Float.parseFloat(tokenizer.sval);
        } else if (this.defaultValue != null) {
            tokenizer.pushBack();
            value = ((Float)this.defaultValue).floatValue();
        } else {
            throw new AnimScriptLoader.SyntaxException(tokenizer, "No value set for this argument, which has no default value");
        }
        return Float.valueOf(value);
    }

    static enum Domain {
        DIMENSION,
        DURATION,
        SCALAR;

    }
}

