/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.menu;

import com.agateau.ui.Scene2dUtils;
import com.agateau.ui.menu.CornerMenuItem;
import com.agateau.ui.menu.FocusIndicator;
import com.agateau.ui.menu.Menu;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;

public class CornerMenuButton
extends ImageButton
implements CornerMenuItem {
    private final Rectangle mRect = new Rectangle();
    private final FocusIndicator mFocusIndicator;
    private final CornerMenuItem.Corner mCorner;

    public CornerMenuButton(Menu menu, CornerMenuItem.Corner corner, ImageButton.ImageButtonStyle style) {
        super(style);
        this.mFocusIndicator = new FocusIndicator(menu);
        this.mCorner = corner;
    }

    @Override
    public CornerMenuItem.Corner getCorner() {
        return this.mCorner;
    }

    @Override
    public Actor getActor() {
        return this;
    }

    @Override
    public boolean isFocusable() {
        return !this.isDisabled();
    }

    @Override
    public void trigger() {
        Scene2dUtils.simulateClick(this);
    }

    @Override
    public boolean goUp() {
        return false;
    }

    @Override
    public boolean goDown() {
        return false;
    }

    @Override
    public void goLeft() {
    }

    @Override
    public void goRight() {
    }

    @Override
    public Rectangle getFocusRectangle() {
        this.mRect.x = 0.0f;
        this.mRect.y = 0.0f;
        this.mRect.width = this.getWidth();
        this.mRect.height = this.getHeight();
        return this.mRect;
    }

    @Override
    public float getParentWidthRatio() {
        return 0.0f;
    }

    @Override
    public void setFocused(boolean focused) {
        this.mFocusIndicator.setFocused(focused);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.mFocusIndicator.act(delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.mFocusIndicator.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        super.draw(batch, parentAlpha);
    }
}

