/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;

public class AgcMathUtils {
    private static final Vector2 sTmpVector = new Vector2();
    public static final float msToKmh = 3.6f;
    public static final float kmhToMs = 0.2777778f;
    private static final float SNAP_ANGLE_THRESHOLD = 2.0f;

    public static float normalizeAngle(float angle) {
        return AgcMathUtils.modulo(angle, 360.0f);
    }

    public static float normalizeAngleRad(float angle) {
        return AgcMathUtils.modulo(angle, (float)Math.PI * 2);
    }

    public static float normalizeAngle180(float angle) {
        if ((angle = AgcMathUtils.normalizeAngle(angle)) > 180.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    public static float normalizeAnglePiRad(float angle) {
        if ((angle = AgcMathUtils.normalizeAngleRad(angle)) > (float)Math.PI) {
            angle -= (float)Math.PI * 2;
        }
        return angle;
    }

    public static float arrayLerp(float[] array, float k) {
        float k2 = (k = MathUtils.clamp(k, 0.0f, 1.0f)) * (float)(array.length - 1);
        int idx = MathUtils.floor(k2);
        if (idx >= array.length - 1) {
            return array[array.length - 1];
        }
        return MathUtils.lerp(array[idx], array[idx + 1], k2 - (float)idx);
    }

    public static Vector2 computeWidthVector(Vector2 pos1, Vector2 pos2, float width) {
        sTmpVector.set(pos2).sub(pos1).nor();
        sTmpVector.set(-AgcMathUtils.sTmpVector.y, AgcMathUtils.sTmpVector.x).scl(width);
        return sTmpVector;
    }

    public static Vector2 project(Vector2 a, Vector2 pos1, Vector2 pos2) {
        sTmpVector.set(pos2).sub(pos1).nor();
        float vx = AgcMathUtils.sTmpVector.x;
        float vy = AgcMathUtils.sTmpVector.y;
        float pos1ToH = (a.x - pos1.x) * vx + (a.y - pos1.y) * vy;
        AgcMathUtils.sTmpVector.x = pos1.x + pos1ToH * vx;
        AgcMathUtils.sTmpVector.y = pos1.y + pos1ToH * vy;
        return sTmpVector;
    }

    public static float segmentAngle(Vector2 pos1, Vector2 pos2) {
        return (float)Math.atan2(pos2.y - pos1.y, pos2.x - pos1.x) * 57.295776f;
    }

    public static void adjustRectangle(Rectangle rect, float amount) {
        rect.x -= amount;
        rect.y -= amount;
        rect.width += 2.0f * amount;
        rect.height += 2.0f * amount;
    }

    public static float angleDelta(float angle1, float angle2) {
        return AgcMathUtils.normalizeAngle(angle2) - AgcMathUtils.normalizeAngle(angle1);
    }

    public static float shortestAngleDelta(float angle1, float angle2) {
        if (angle2 - angle1 > 180.0f) {
            angle2 -= 360.0f;
        }
        if (angle1 - angle2 > 180.0f) {
            angle1 -= 360.0f;
        }
        return angle2 - angle1;
    }

    public static boolean anglesAreEqual(float angle1, float angle2, float tolerance) {
        return MathUtils.isZero(AgcMathUtils.shortestAngleDelta(angle1, angle2), tolerance);
    }

    public static float modulo(float value, float divisor) {
        while (value < 0.0f) {
            value += divisor;
        }
        return value % divisor;
    }

    public static boolean isQuadrilateralConvex(Vector2 p1, Vector2 p2, Vector2 p3, Vector2 p4) {
        return AgcMathUtils.lineCrossesSegment(p1, p3, p2, p4) && AgcMathUtils.lineCrossesSegment(p2, p4, p1, p3);
    }

    public static boolean lineCrossesSegment(Vector2 lineP, Vector2 lineQ, Vector2 segmentP1, Vector2 segmentP2) {
        int side2;
        int side1 = AgcMathUtils.lineCrossesSegmentHelper(lineP, lineQ, segmentP1);
        return side1 != (side2 = AgcMathUtils.lineCrossesSegmentHelper(lineP, lineQ, segmentP2));
    }

    private static int lineCrossesSegmentHelper(Vector2 lineP, Vector2 lineQ, Vector2 point) {
        float f = (point.x - lineP.x) / (lineQ.x - lineP.x) - (point.y - lineP.y) / (lineQ.y - lineP.y);
        return f > 0.0f ? 1 : (f < 0.0f ? -1 : 0);
    }

    public static boolean rectangleContains(Rectangle rect, Vector2 position, float radius) {
        if (position.x - radius > rect.x + rect.width) {
            return false;
        }
        if (position.x + radius < rect.x) {
            return false;
        }
        if (position.y - radius > rect.y + rect.height) {
            return false;
        }
        return !(position.y + radius < rect.y);
    }

    public static float snapAngle(float value) {
        float snappedValue = (float)MathUtils.round(value / 90.0f) * 90.0f;
        if (Math.abs(snappedValue - value) <= 2.0f) {
            return snappedValue;
        }
        return value;
    }
}

