/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.utils.log;

import com.agateau.utils.log.SystemErrPrinter;
import java.util.Vector;

public class NLog {
    private static final Vector<Printer> sPrinters = new Vector();
    private static int sStackDepth = -1;

    public static void d(Object obj, Object ... args) {
        NLog.print(Level.DEBUG, obj, args);
    }

    public static void i(Object obj, Object ... args) {
        NLog.print(Level.INFO, obj, args);
    }

    public static void e(Object obj, Object ... args) {
        NLog.print(Level.ERROR, obj, args);
    }

    public static void backtrace() {
        StackTraceElement[] lst = Thread.currentThread().getStackTrace();
        int n = lst.length;
        for (int idx = 2; idx < n; ++idx) {
            NLog.d("bt: %s", lst[idx]);
        }
    }

    public static void clearPrinters() {
        sPrinters.clear();
    }

    public static void addPrinter(Printer printer) {
        sPrinters.add(printer);
    }

    static synchronized void print(Level level, Object obj, Object ... args) {
        if (sStackDepth < 0) {
            NLog.initStackDepth();
        }
        NLog.print(level, NLog.getCallerMethod(), obj, args);
    }

    static synchronized void print(Level level, String tag, Object obj, Object ... args) {
        String message;
        if (obj == null) {
            message = "(null)";
        } else {
            String format = obj.toString();
            String string = message = args.length > 0 ? String.format(format, args) : format;
        }
        if (sPrinters.isEmpty()) {
            sPrinters.add(new SystemErrPrinter());
        }
        for (Printer printer : sPrinters) {
            printer.print(level, tag, message);
        }
    }

    private static void initStackDepth() {
        StackTraceElement[] lst = Thread.currentThread().getStackTrace();
        int n = lst.length;
        for (int i = 0; i < n; ++i) {
            if (!lst[i].getMethodName().equals("initStackDepth")) continue;
            sStackDepth = i;
            return;
        }
    }

    private static String getCallerMethod() {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[sStackDepth + 3];
        String fullClassName = stackTraceElement.getClassName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        String method = stackTraceElement.getMethodName();
        return className + "." + method;
    }

    public static enum Level {
        DEBUG,
        INFO,
        ERROR;

    }

    public static interface Printer {
        public void print(Level var1, String var2, String var3);
    }
}

