/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels;

import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.Languages;
import com.agateau.pixelwheels.TextureRegionProvider;
import com.agateau.pixelwheels.gameobject.AnimationObject;
import com.agateau.pixelwheels.gamesetup.Difficulty;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.map.ChampionshipIO;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.obstacles.ObstacleDef;
import com.agateau.pixelwheels.obstacles.ObstacleIO;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.sound.SoundAtlas;
import com.agateau.pixelwheels.utils.StringUtils;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.pixelwheels.vehicledef.VehicleIO;
import com.agateau.translations.PoImplementation;
import com.agateau.translations.Translator;
import com.agateau.ui.FontSet;
import com.agateau.ui.StrictTextureAtlas;
import com.agateau.ui.UiAssets;
import com.agateau.utils.Assert;
import com.agateau.utils.FileUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.ParticleEffectPool;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import java.util.HashMap;

public class Assets
implements TextureRegionProvider {
    private static final float EXPLOSION_FRAME_DURATION = 0.1f;
    private static final float IMPACT_FRAME_DURATION = 0.05f;
    private static final float MINE_FRAME_DURATION = 0.2f;
    private static final float TURBO_FRAME_DURATION = 0.1f;
    private static final float TURBO_FLAME_FRAME_DURATION = 0.04f;
    private static final String[] VEHICLE_IDS = new String[]{"red", "police", "antonin", "pickup", "harvester", "jeep", "bigfoot", "2cv", "c15", "miramar", "rocket", "dark-m", "roadster", "santa", "old-f1"};
    public static final String MENU_MUSIC_ID = "menu";
    public static final String CHAMPIONSHIP_FINISHED_MUSIC_ID = "victory";
    public static final String CURSOR_FILENAME = "ui/cursor.png";
    public final Array<VehicleDef> vehicleDefs = new Array();
    public final Array<Championship> championships = new Array();
    public final Array<ObstacleDef> obstacleDefs = new Array();
    public UiAssets ui;
    public final TextureRegion dot;
    public final TextureAtlas atlas;
    public final Animation<TextureRegion> impact;
    public final Animation<TextureRegion> mine;
    public final Animation<TextureRegion> turbo;
    public final Animation<TextureRegion> turboFlame;
    public final TextureRegion gift;
    public final Animation<TextureRegion> gunAnimation;
    public final TextureRegion bullet;
    public final TextureRegion skidmark;
    public final TextureRegion missile;
    public final TextureRegion target;
    public final TextureRegion helicopterBody;
    public final TextureRegion helicopterPropeller;
    public final TextureRegion helicopterPropellerTop;
    public final TextureRegion lockedVehicle;
    public ParticleEffectPool smokeEffectPool;
    public final SoundAtlas soundAtlas = new SoundAtlas(FileUtils.assets("sounds"));
    public final Languages languages = new Languages(FileUtils.assets("ui/languages.xml"));
    private final Animation<TextureRegion> explosion;

    public Assets() {
        this.atlas = new StrictTextureAtlas(FileUtils.assets("sprites/sprites.atlas"));
        this.explosion = new Animation<TextureAtlas.AtlasRegion>(0.1f, this.atlas.findRegions("explosion"));
        this.impact = new Animation<TextureAtlas.AtlasRegion>(0.05f, this.atlas.findRegions("impact"));
        this.mine = new Animation<TextureAtlas.AtlasRegion>(0.2f, this.atlas.findRegions("mine"));
        this.mine.setPlayMode(Animation.PlayMode.LOOP);
        this.turbo = new Animation<TextureAtlas.AtlasRegion>(0.1f, this.atlas.findRegions("bonus-turbo"));
        this.turboFlame = new Animation<TextureAtlas.AtlasRegion>(0.04f, this.atlas.findRegions("turbo-flame"));
        this.turboFlame.setPlayMode(Animation.PlayMode.LOOP_PINGPONG);
        this.gift = this.findRegion("gift");
        this.gunAnimation = new Animation<TextureAtlas.AtlasRegion>(0.033333335f, this.atlas.findRegions("bonus-gun"));
        this.bullet = this.findRegion("bullet");
        this.dot = this.findRegion("white-pixel");
        Assets.removeBorders(this.dot);
        this.skidmark = this.findRegion("skidmark");
        this.missile = this.findRegion("missile");
        this.target = this.findRegion("target");
        this.helicopterBody = this.findRegion("helicopter-body");
        this.helicopterPropeller = this.findRegion("helicopter-propeller");
        this.helicopterPropellerTop = this.findRegion("helicopter-propeller-top");
        this.lockedVehicle = this.findRegion("vehicles/locked");
        this.loadVehicleDefinitions();
        this.loadObstacleDefinitions();
        this.loadParticleEffects();
        this.initSoundAtlas();
        this.initChampionships();
    }

    public void setLanguage(String languageId) {
        String path = StringUtils.format("po/%s.po", languageId);
        FileHandle handle = FileUtils.assets(path);
        PoImplementation impl = PoImplementation.load(handle);
        Translator.setImplementation(impl);
        if (impl == null && !"en".equals(languageId)) {
            NLog.e("Failed to load translation for '%s'", languageId);
            languageId = "en";
        }
        String characters = impl == null ? "" : impl.getCharacters();
        FontSet fontSet = this.languages.getFontSet(languageId);
        if (this.ui != null) {
            this.ui.dispose();
        }
        this.ui = new UiAssets(fontSet, characters);
    }

    private void initSoundAtlas() {
        for (int i = 0; i < 5; ++i) {
            String name = StringUtils.format("engine-%d", i);
            String filename = StringUtils.format("loop_%d_0.wav", i + 1);
            this.soundAtlas.load(filename, name);
        }
        this.soundAtlas.load("drifting.wav");
        this.soundAtlas.load("bonus.wav");
        this.soundAtlas.load("explosion.wav");
        this.soundAtlas.load("shoot.wav");
        this.soundAtlas.load("impact.wav");
        this.soundAtlas.load("turbo.wav");
        this.soundAtlas.load("impact.wav", "collision");
        this.soundAtlas.load("helicopter.wav");
        this.soundAtlas.load("missile.wav");
        this.soundAtlas.load("countdown1.wav");
        this.soundAtlas.load("countdown2.wav");
        this.soundAtlas.load("splash.wav");
        this.soundAtlas.load("points-increase.wav");
    }

    public Music loadMusic(String musicId) {
        FileHandle handle = FileUtils.assets("musics/" + musicId + ".mp3");
        if (!handle.exists()) {
            NLog.e("No music with id " + musicId, new Object[0]);
            return null;
        }
        return Gdx.audio.newMusic(handle);
    }

    public String getTrackMusicId(Track track) {
        Championship championship = track.getChampionship();
        return "championships/" + championship.getId();
    }

    private void initChampionships() {
        String fileName;
        FileHandle handle;
        HashMap<Difficulty, Integer> maxDrivingForceByDifficulty = new HashMap<Difficulty, Integer>();
        for (Difficulty difficulty : Difficulty.values()) {
            maxDrivingForceByDifficulty.put(difficulty, GamePlay.instance.getMaxDrivingForce(difficulty));
        }
        ChampionshipIO io = new ChampionshipIO(maxDrivingForceByDifficulty);
        int idx = 0;
        while ((handle = FileUtils.assets(fileName = "championships/" + idx + ".xml")).exists()) {
            this.championships.add(io.load(handle));
            ++idx;
        }
        Assert.check(this.championships.notEmpty(), "No championships found", new Object[0]);
    }

    private static void removeBorders(TextureRegion region) {
        region.setRegionX(region.getRegionX() + 2);
        region.setRegionY(region.getRegionY() + 2);
        region.setRegionWidth(region.getRegionWidth() - 4);
        region.setRegionHeight(region.getRegionHeight() - 4);
    }

    @Override
    public TextureRegion findRegion(String name) {
        return this.atlas.findRegion(name);
    }

    @Override
    public Array<TextureAtlas.AtlasRegion> findRegions(String name) {
        return this.atlas.findRegions(name);
    }

    public VehicleDef findVehicleDefById(String id) {
        for (VehicleDef def : this.vehicleDefs) {
            if (!def.id.equals(id)) continue;
            return def;
        }
        return null;
    }

    public Championship findChampionshipById(String id) {
        for (Championship championship : this.championships) {
            if (!championship.getId().equals(id)) continue;
            return championship;
        }
        return null;
    }

    public Track findTrackById(String id) {
        for (Championship championship : this.championships) {
            for (Track track : championship.getTracks()) {
                if (!track.getId().equals(id)) continue;
                return track;
            }
        }
        return null;
    }

    public AnimationObject createExplosion(AudioManager audioManager, float x, float y) {
        AnimationObject obj = AnimationObject.create(this.explosion, x, y);
        obj.initAudio(audioManager, this.soundAtlas.get("explosion"));
        return obj;
    }

    public TextureRegion getChampionshipRegion(Championship championship) {
        return this.ui.atlas.findRegion("championship-icons/" + championship.getId());
    }

    public TextureRegion getTrackRegion(Track track) {
        return this.ui.atlas.findRegion("map-icons/" + track.getId());
    }

    public TextureRegion getLockedTrackRegion() {
        return this.ui.atlas.findRegion("map-icons/locked");
    }

    private void loadVehicleDefinitions() {
        for (String id : VEHICLE_IDS) {
            this.vehicleDefs.add(VehicleIO.get(id));
        }
    }

    private void loadObstacleDefinitions() {
        this.obstacleDefs.clear();
        this.obstacleDefs.addAll(ObstacleIO.getAll(this));
    }

    private void loadParticleEffects() {
        ParticleEffect smokeEffect = new ParticleEffect();
        smokeEffect.load(FileUtils.assets("particles/smoke.p"), this.atlas);
        this.smokeEffectPool = new ParticleEffectPool(smokeEffect, 5, 10);
    }
}

