/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.debug;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.HashMap;

public class DebugStringMap {
    private static final String[] PERCENT_VALUES = new String[10];
    private static final HashMap<String, String> sMap;

    public static HashMap<String, String> getMap() {
        return sMap;
    }

    public static void put(String key, Object message) {
        sMap.put(key, message.toString());
    }

    public static void putPercent(String key, float percent) {
        int idx = MathUtils.clamp((int)(percent * (float)PERCENT_VALUES.length), 0, PERCENT_VALUES.length - 1);
        sMap.put(key, PERCENT_VALUES[idx]);
    }

    static {
        StringBuilder builder = new StringBuilder();
        builder.setLength(PERCENT_VALUES.length - 1);
        for (int row = 0; row < PERCENT_VALUES.length; ++row) {
            for (int idx = 0; idx < builder.length; ++idx) {
                builder.setCharAt(idx, idx < row ? (char)'*' : '_');
            }
            DebugStringMap.PERCENT_VALUES[row] = builder.toString();
        }
        sMap = new HashMap();
    }
}

