/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gameinput;

import com.agateau.pixelwheels.gameinput.GameInputHandler;
import com.agateau.pixelwheels.gameinput.GameInputHandlerFactory;
import com.agateau.pixelwheels.gameinput.InputMapperInputHandler;
import com.agateau.translations.Translator;
import com.agateau.ui.DefaultKeys;
import com.agateau.ui.KeyMapper;
import com.badlogic.gdx.utils.Array;

public class KeyboardInputHandler
extends InputMapperInputHandler {
    KeyboardInputHandler(KeyMapper keyMapper) {
        super(keyMapper);
    }

    public KeyMapper getKeyMapper() {
        return (KeyMapper)this.getInputMapper();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getTypeName() {
        return Translator.tr("Keyboard");
    }

    public static class Factory
    implements GameInputHandlerFactory {
        final Array<GameInputHandler> mHandlers = new Array();

        Factory() {
            for (int idx = 0; idx < DefaultKeys.getDefaultKeysCount(); ++idx) {
                KeyMapper keyMapper = KeyMapper.createGameInstance(idx);
                this.mHandlers.add(new KeyboardInputHandler(keyMapper));
            }
        }

        @Override
        public String getId() {
            return "keyboard";
        }

        @Override
        public String getName() {
            return Translator.tr("Keyboard");
        }

        @Override
        public Array<GameInputHandler> getAllHandlers() {
            return this.mHandlers;
        }
    }
}

