/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gameinput;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.bonus.Bonus;
import com.agateau.pixelwheels.gameinput.DigitalSteering;
import com.agateau.pixelwheels.gameinput.GameInput;
import com.agateau.pixelwheels.gameinput.GameInputHandler;
import com.agateau.pixelwheels.gameinput.GameInputHandlerFactory;
import com.agateau.pixelwheels.racescreen.Hud;
import com.agateau.pixelwheels.racescreen.HudButton;
import com.agateau.translations.Translator;
import com.agateau.ui.anchor.Anchor;
import com.agateau.ui.anchor.AnchorGroup;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.utils.Array;

public class SidesTouchInputHandler
implements GameInputHandler {
    private final GameInput mInput = new GameInput();
    private final DigitalSteering mSteer = new DigitalSteering();
    private HudButton mLeftButton;
    private HudButton mRightButton;
    private HudButton mBonusButton;

    @Override
    public GameInput getGameInput() {
        this.mInput.braking = this.isBraking();
        this.mInput.accelerating = !this.mInput.braking;
        this.mInput.direction = this.mSteer.steer(this.mLeftButton.isPressed(), this.mRightButton.isPressed());
        this.mInput.triggeringBonus = this.mBonusButton.isPressed();
        return this.mInput;
    }

    @Override
    public void loadConfig(Preferences preferences, String prefix, int playerIdx) {
    }

    @Override
    public void saveConfig(Preferences preferences, String prefix) {
    }

    @Override
    public void createHudButtons(Assets assets, Hud hud) {
        this.mLeftButton = new HudButton(assets, hud, "sides-left");
        this.mRightButton = new HudButton(assets, hud, "sides-right");
        this.mBonusButton = new HudButton(assets, hud, "sides-action");
        this.mBonusButton.setVisible(false);
        AnchorGroup root = hud.getInputUiContainer();
        root.addPositionRule(this.mLeftButton, Anchor.BOTTOM_LEFT, root, Anchor.BOTTOM_LEFT);
        root.addPositionRule(this.mRightButton, Anchor.BOTTOM_RIGHT, root, Anchor.BOTTOM_RIGHT);
        root.addPositionRule(this.mBonusButton, Anchor.CENTER_RIGHT, root, Anchor.CENTER_RIGHT);
    }

    @Override
    public void setBonus(Bonus bonus) {
        this.mBonusButton.setVisible(bonus != null);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getTypeName() {
        return Translator.tr("Side buttons");
    }

    private boolean isBraking() {
        return this.mLeftButton.isPressed() && this.mRightButton.isPressed();
    }

    public static class Factory
    implements GameInputHandlerFactory {
        final Array<GameInputHandler> mHandlers = new Array();

        Factory() {
            this.mHandlers.add(new SidesTouchInputHandler());
        }

        @Override
        public String getId() {
            return "sides";
        }

        @Override
        public String getName() {
            return Translator.tr("Side buttons");
        }

        @Override
        public Array<GameInputHandler> getAllHandlers() {
            return this.mHandlers;
        }
    }
}

