/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gamesetup;

import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.gameinput.EnoughInputsChecker;
import com.agateau.pixelwheels.rewards.Reward;
import com.agateau.pixelwheels.rewards.RewardManager;
import com.agateau.pixelwheels.screens.NavStageScreen;
import com.agateau.pixelwheels.screens.NotEnoughInputsScreen;
import com.agateau.pixelwheels.screens.UnlockedRewardScreen;
import com.agateau.utils.log.NLog;
import java.util.Set;

public abstract class Maestro
implements EnoughInputsChecker.Listener {
    private final PwGame mGame;
    private final int mPlayerCount;
    private final EnoughInputsChecker mEnoughInputsChecker;
    private NotEnoughInputsScreen mNotEnoughInputsScreen;

    public Maestro(PwGame game, int playerCount) {
        this.mGame = game;
        this.mPlayerCount = playerCount;
        this.mEnoughInputsChecker = new EnoughInputsChecker(this.mGame.getConfig(), this);
        this.mEnoughInputsChecker.setInputCount(playerCount);
    }

    public abstract void start();

    public void stopEnoughInputChecker() {
        if (this.mNotEnoughInputsScreen != null) {
            this.hideNotEnoughInputsScreen();
        }
        this.mEnoughInputsChecker.setInputCount(0);
    }

    public int getPlayerCount() {
        return this.mPlayerCount;
    }

    protected PwGame getGame() {
        return this.mGame;
    }

    @Override
    public void onNotEnoughInputs() {
        NLog.e("There aren't enough connected inputs", new Object[0]);
        if (this.mNotEnoughInputsScreen == null) {
            this.mNotEnoughInputsScreen = new NotEnoughInputsScreen(this.mGame, this, this.mEnoughInputsChecker);
            this.mGame.getScreenStack().showBlockingScreen(this.mNotEnoughInputsScreen);
        } else {
            this.mNotEnoughInputsScreen.updateMissingInputs();
        }
    }

    @Override
    public void onEnoughInputs() {
        NLog.i("There are enough connected inputs", new Object[0]);
        this.hideNotEnoughInputsScreen();
    }

    private void hideNotEnoughInputsScreen() {
        this.mGame.getScreenStack().hideBlockingScreen();
        this.mNotEnoughInputsScreen = null;
    }

    void showUnlockedRewardScreen(Runnable doAfterLastReward) {
        RewardManager manager = this.getGame().getRewardManager();
        Set<Reward> rewards = manager.getUnseenUnlockedRewards();
        manager.markAllUnlockedRewardsSeen();
        this.showUnlockedRewardScreen(rewards, doAfterLastReward);
    }

    private void showUnlockedRewardScreen(final Set<Reward> rewards, final Runnable doAfterLastReward) {
        if (rewards.isEmpty()) {
            doAfterLastReward.run();
            return;
        }
        Reward reward = rewards.iterator().next();
        rewards.remove(reward);
        NavStageScreen.NextListener navListener = new NavStageScreen.NextListener(){

            @Override
            public void onNextPressed() {
                Maestro.this.showUnlockedRewardScreen(rewards, doAfterLastReward);
            }
        };
        this.getGame().replaceScreen(new UnlockedRewardScreen(this.getGame(), reward, navListener));
    }
}

