/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gamesetup;

import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.debug.Debug;
import com.agateau.pixelwheels.gamesetup.GameInfo;
import com.agateau.pixelwheels.gamesetup.Maestro;
import com.agateau.pixelwheels.gamesetup.QuickRaceGameInfo;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.racescreen.RaceScreen;
import com.agateau.pixelwheels.screens.MultiPlayerScreen;
import com.agateau.pixelwheels.screens.SelectTrackScreen;
import com.agateau.pixelwheels.screens.SelectVehicleScreen;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.utils.Array;

public class QuickRaceMaestro
extends Maestro {
    private final QuickRaceGameInfo.Builder mGameInfoBuilder;

    public QuickRaceMaestro(PwGame game, int playerCount) {
        super(game, playerCount);
        this.mGameInfoBuilder = new QuickRaceGameInfo.Builder(game.getAssets().vehicleDefs, game.getConfig());
    }

    @Override
    public void start() {
        this.getGame().pushScreen(this.createSelectTrackScreen());
    }

    private Screen createSelectVehicleScreen() {
        if (this.getPlayerCount() == 1) {
            return this.createOnePlayerVehicleScreen();
        }
        return this.createMultiPlayerVehicleScreen();
    }

    private Screen createOnePlayerVehicleScreen() {
        SelectVehicleScreen.Listener listener = new SelectVehicleScreen.Listener(){

            @Override
            public void onBackPressed() {
                QuickRaceMaestro.this.getGame().replaceScreen(QuickRaceMaestro.this.createSelectTrackScreen());
            }

            @Override
            public void onPlayerSelected(GameInfo.Player player) {
                Array<GameInfo.Player> players = new Array<GameInfo.Player>();
                players.add(player);
                QuickRaceMaestro.this.mGameInfoBuilder.setPlayers(players);
                QuickRaceMaestro.this.getGame().replaceScreen(QuickRaceMaestro.this.createRaceScreen());
            }
        };
        return new SelectVehicleScreen(this.getGame(), listener);
    }

    private Screen createMultiPlayerVehicleScreen() {
        MultiPlayerScreen.Listener listener = new MultiPlayerScreen.Listener(){

            @Override
            public void onBackPressed() {
                QuickRaceMaestro.this.getGame().replaceScreen(QuickRaceMaestro.this.createSelectTrackScreen());
            }

            @Override
            public void onPlayersSelected(Array<GameInfo.Player> players) {
                QuickRaceMaestro.this.mGameInfoBuilder.setPlayers(players);
                QuickRaceMaestro.this.getGame().replaceScreen(QuickRaceMaestro.this.createRaceScreen());
            }
        };
        return new MultiPlayerScreen(this.getGame(), this.getPlayerCount(), listener);
    }

    private Screen createSelectTrackScreen() {
        SelectTrackScreen.Listener listener = new SelectTrackScreen.Listener(){

            @Override
            public void onBackPressed() {
                QuickRaceMaestro.this.stopEnoughInputChecker();
                QuickRaceMaestro.this.getGame().popScreen();
            }

            @Override
            public void onTrackSelected(Track track) {
                QuickRaceMaestro.this.mGameInfoBuilder.setTrack(track);
                QuickRaceMaestro.this.getGame().replaceScreen(QuickRaceMaestro.this.createSelectVehicleScreen());
            }
        };
        return new SelectTrackScreen(this.getGame(), listener);
    }

    private Screen createRaceScreen() {
        final QuickRaceGameInfo gameInfo = this.mGameInfoBuilder.build();
        RaceScreen.Listener listener = new RaceScreen.Listener(){

            @Override
            public void onRestartPressed() {
                ((RaceScreen)QuickRaceMaestro.this.getGame().getScreen()).forgetTrack();
                if (Debug.instance.refreshAssetsOnRestart) {
                    QuickRaceMaestro.this.getGame().refreshAssets();
                    Track track = QuickRaceMaestro.this.getGame().getAssets().findTrackById(gameInfo.getTrack().getId());
                    QuickRaceMaestro.this.mGameInfoBuilder.setTrack(track);
                }
                QuickRaceMaestro.this.getGame().replaceScreen(QuickRaceMaestro.this.createRaceScreen());
            }

            @Override
            public void onQuitPressed() {
                QuickRaceMaestro.this.stopEnoughInputChecker();
                QuickRaceMaestro.this.getGame().showMainMenu();
            }

            @Override
            public void onNextTrackPressed() {
                QuickRaceMaestro.this.stopEnoughInputChecker();
                QuickRaceMaestro.this.showUnlockedRewardScreen(() -> QuickRaceMaestro.this.getGame().showMainMenu());
            }
        };
        return new RaceScreen(this.getGame(), listener, gameInfo);
    }
}

