/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.agateau.utils.Assert;

public enum Material {
    ROAD,
    TURBO,
    SAND,
    SNOW,
    DEEP_WATER,
    WATER,
    AIR,
    ICE;


    public boolean isHole() {
        return this == DEEP_WATER;
    }

    public boolean isWater() {
        return this == DEEP_WATER || this == WATER;
    }

    public boolean isRoad() {
        return this == ROAD || this == TURBO || this == ICE;
    }

    public float getSpeed() {
        switch (this) {
            case ROAD: {
                return 1.0f;
            }
            case TURBO: {
                return 4.0f;
            }
            case SAND: {
                return 0.6f;
            }
            case SNOW: {
                return 0.5f;
            }
            case DEEP_WATER: {
                return 0.0f;
            }
            case WATER: {
                return 0.3f;
            }
            case AIR: {
                return 0.0f;
            }
            case ICE: {
                return 0.3f;
            }
        }
        Assert.check(false, "Missing material speed for " + this.toString(), new Object[0]);
        return 0.0f;
    }

    public float getGrip() {
        float grip = 1.0f;
        if (this == ICE) {
            grip /= 10.0f;
        }
        return grip;
    }
}

