/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.racescreen.Hud;
import com.agateau.pixelwheels.racescreen.HudButton;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;

public class PieButton
extends HudButton {
    private float mFrom = 0.0f;
    private float mTo = 90.0f;

    public PieButton(Assets assets, Hud hud, String name) {
        super(assets, hud, name);
    }

    public void setSector(int from, int to) {
        this.mFrom = from;
        this.mTo = to;
    }

    private boolean isOnTheRight() {
        return this.mFrom >= 90.0f;
    }

    @Override
    public Actor hit(float x, float y, boolean touchable) {
        if (y >= this.getHud().getInputUiHeight()) {
            return null;
        }
        if (this.isOnTheRight() ? (x -= this.getWidth()) <= -this.getHud().getInputUiWidth() / 2.0f : x >= this.getHud().getInputUiWidth() / 2.0f) {
            return null;
        }
        float angle = MathUtils.atan2(y, x) * 57.295776f;
        if (this.mFrom <= angle && angle <= this.mTo) {
            return this;
        }
        return null;
    }
}

