/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.gameinput.GameInputHandler;
import com.agateau.pixelwheels.gameinput.InputMapperInputHandler;
import com.agateau.pixelwheels.gamesetup.GameInfo;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.pixelwheels.screens.VehicleSelector;
import com.agateau.pixelwheels.utils.StringUtils;
import com.agateau.pixelwheels.utils.UiUtils;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.translations.Translator;
import com.agateau.ui.InputMapper;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.GridMenuItem;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;

public class MultiPlayerScreen
extends PwStageScreen {
    private final PwGame mGame;
    private final int mPlayerCount;
    private final Listener mListener;
    private final InputMapper[] mInputMappers;
    private VehicleSelector mVehicleSelector;
    private final Array<Label> mReadyLabels = new Array();

    public MultiPlayerScreen(PwGame game, int playerCount, Listener listener) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.mPlayerCount = playerCount;
        this.mListener = listener;
        this.mInputMappers = new InputMapper[this.mPlayerCount];
        for (int idx = 0; idx < this.mPlayerCount; ++idx) {
            InputMapper inputMapper;
            GameInputHandler inputHandler = this.mGame.getConfig().getPlayerInputHandler(idx);
            this.mInputMappers[idx] = inputMapper = ((InputMapperInputHandler)inputHandler).getInputMapper();
        }
        this.setupUi();
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                MultiPlayerScreen.this.mGame.replaceScreen(new MultiPlayerScreen(MultiPlayerScreen.this.mGame, MultiPlayerScreen.this.mPlayerCount, MultiPlayerScreen.this.mListener));
            }
        };
    }

    private void setupUi() {
        Assets assets = this.mGame.getAssets();
        UiBuilder builder = UiUtils.createUiBuilder(assets);
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/multiplayer.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        this.createVehicleSelector(builder, assets);
        this.createReadyLabels(builder, assets);
        for (int idx = 0; idx < this.mPlayerCount; ++idx) {
            this.setupCursor(assets, idx);
        }
        Menu menu = (Menu)builder.getActor("menu");
        menu.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                MultiPlayerScreen.this.onBackPressed();
            }
        });
    }

    private void createReadyLabels(UiBuilder builder, Assets assets) {
        Skin skin = assets.ui.skin;
        HorizontalGroup group = (HorizontalGroup)builder.getActor("readyGroup");
        this.mReadyLabels.clear();
        for (int idx = 0; idx < this.mPlayerCount; ++idx) {
            String style = StringUtils.format("player%d", idx + 1);
            Label label = new Label("", skin, style);
            group.addActor(label);
            this.mReadyLabels.add(label);
            this.setReadyLabelText(idx, null);
        }
    }

    private void setReadyLabelText(int idx, String name) {
        Label label = this.mReadyLabels.get(idx);
        String textTemplate = Translator.trc("P%d: %s", "The 'P' is for 'Player'");
        String text = StringUtils.format(textTemplate, idx + 1, name == null ? "..." : name);
        label.setText(text);
        WidgetGroup group = (WidgetGroup)label.getParent();
        group.pack();
    }

    @Override
    public void onBackPressed() {
        this.mListener.onBackPressed();
    }

    private void createVehicleSelector(UiBuilder builder, Assets assets) {
        Menu menu = (Menu)builder.getActor("menu");
        this.mVehicleSelector = new VehicleSelector(menu);
        this.mVehicleSelector.setMenuStyle(menu.getMenuStyleByName("large"));
        this.mVehicleSelector.init(assets, this.mGame.getRewardManager());
        this.mVehicleSelector.setColumnCount(builder.getIntConfigValue("columnCount"));
        this.mVehicleSelector.setItemSize(builder.getIntConfigValue("itemWidth"), builder.getIntConfigValue("itemHeight"));
        menu.addItem(this.mVehicleSelector);
    }

    private void setupCursor(Assets assets, final int idx) {
        if (idx > 0) {
            this.mVehicleSelector.addCursor();
            this.mVehicleSelector.setInputMapper(idx, this.mInputMappers[idx]);
        }
        Menu.MenuStyle menuStyle = assets.ui.skin.get("player" + (idx + 1), Menu.MenuStyle.class);
        this.mVehicleSelector.setMenuStyle(idx, menuStyle);
        String vehicleId = this.mGame.getConfig().vehicles[idx];
        VehicleDef vehicleDef = assets.findVehicleDefById(vehicleId);
        this.mVehicleSelector.setCurrent(idx, vehicleDef);
        this.mVehicleSelector.setSelectionListener(idx, new GridMenuItem.SelectionListener<VehicleDef>(){

            @Override
            public void currentChanged(VehicleDef item, int index) {
            }

            @Override
            public void selectionConfirmed() {
                VehicleDef vehicleDef = (VehicleDef)MultiPlayerScreen.this.mVehicleSelector.getSelected(idx);
                MultiPlayerScreen.this.setReadyLabelText(idx, vehicleDef.getName());
                MultiPlayerScreen.this.nextIfPossible();
            }
        });
    }

    private void nextIfPossible() {
        for (int idx = 0; idx < this.mPlayerCount; ++idx) {
            if (this.mVehicleSelector.getSelected(idx) != null) continue;
            return;
        }
        this.next();
    }

    private void next() {
        Array<GameInfo.Player> players = new Array<GameInfo.Player>();
        for (int idx = 0; idx < this.mPlayerCount; ++idx) {
            VehicleDef vehicleDef = (VehicleDef)this.mVehicleSelector.getSelected(idx);
            if (vehicleDef == null) {
                return;
            }
            players.add(new GameInfo.Player(idx, vehicleDef.id));
        }
        this.mListener.onPlayersSelected(players);
    }

    public static interface Listener {
        public void onBackPressed();

        public void onPlayersSelected(Array<GameInfo.Player> var1);
    }
}

