/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.screens.DifficultySelectorController;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.pixelwheels.screens.SelectGameModeScreen;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItemListener;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

public class SelectPlayerCountScreen
extends PwStageScreen {
    private final PwGame mGame;

    public SelectPlayerCountScreen(PwGame game) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.setupUi();
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                SelectPlayerCountScreen.this.mGame.replaceScreen(new SelectPlayerCountScreen(SelectPlayerCountScreen.this.mGame));
            }
        };
    }

    private void setupUi() {
        UiBuilder builder = new UiBuilder(this.mGame.getAssets().ui.atlas, this.mGame.getAssets().ui.skin);
        DifficultySelectorController.registerFactory(builder, this.mGame.getConfig());
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/selectplayercount.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        for (int idx = 2; idx <= 4; ++idx) {
            final int playerCount = idx;
            ((Actor)builder.getActor(idx + "PlayersButton")).addListener(new MenuItemListener(){

                @Override
                public void triggered() {
                    SelectPlayerCountScreen.this.mGame.pushScreen(new SelectGameModeScreen(SelectPlayerCountScreen.this.mGame, playerCount));
                }
            });
        }
        Menu menu = (Menu)builder.getActor("menu");
        menu.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SelectPlayerCountScreen.this.onBackPressed();
            }
        });
    }

    @Override
    public void onBackPressed() {
        this.mGame.popScreen();
    }
}

