/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.sound;

import com.agateau.utils.log.NLog;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.utils.Timer;

class MusicFader
extends Timer.Task {
    private static final float FADEOUT_DURATION = 1.0f;
    private static final float UPDATE_INTERVAL = 0.05f;
    private Music mMusic;

    MusicFader() {
    }

    @Override
    public void run() {
        float volume = this.mMusic.getVolume();
        if ((volume -= 0.05f) > 0.0f) {
            this.mMusic.setVolume(volume);
            Timer.schedule(this, 0.05f);
        } else {
            this.mMusic.stop();
            this.mMusic.dispose();
            this.mMusic = null;
        }
    }

    public void fadeOut(Music music) {
        if (music == null) {
            return;
        }
        if (this.mMusic != null) {
            if (this.mMusic == music) {
                return;
            }
            NLog.i("We are currently fading music A, but we must now fade music B, abruptly stopping A", new Object[0]);
            this.mMusic.stop();
            this.mMusic.dispose();
        }
        this.mMusic = music;
        if (!this.isScheduled()) {
            Timer.post(this);
        }
    }
}

