/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.utils;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;

public class BodyRegionDrawer {
    public static final float SHADOW_ALPHA = 0.35f;
    public static final float SHADOW_OFFSET_PX = 3.0f;
    private static final int Z_MAX_SHADOW_OFFSET_PX = 30;
    private static final int SCALE_MAX_SHADOW_OFFSET_PX = 30;
    private Batch mBatch;
    private float mZ = 0.0f;
    private float mScale = 1.0f;
    private float mOffsetX = 0.0f;
    private float mOffsetY = 0.0f;

    public void setBatch(Batch batch) {
        this.mBatch = batch;
    }

    public void setZ(float z) {
        this.mZ = z;
    }

    public void setScale(float scale) {
        this.mScale = scale;
    }

    public void setOffset(float x, float y) {
        this.mOffsetX = x;
        this.mOffsetY = y;
    }

    public void draw(Body body, TextureRegion region) {
        Vector2 center = body.getPosition();
        float angle = body.getAngle();
        float x = center.x + this.mOffsetX * MathUtils.cos(angle) - this.mOffsetY * MathUtils.sin(angle);
        float y = center.y + this.mOffsetX * MathUtils.sin(angle) + this.mOffsetY * MathUtils.cos(angle);
        float w = 0.05f * (float)region.getRegionWidth();
        float h = 0.05f * (float)region.getRegionHeight();
        this.mBatch.draw(region, x - w / 2.0f, y - h / 2.0f, w / 2.0f, h / 2.0f, w, h, this.mScale, this.mScale, angle * 57.295776f);
    }

    public void drawShadow(Body body, TextureRegion region) {
        Vector2 center = body.getPosition();
        float angle = body.getAngle() * 57.295776f;
        float offset = BodyRegionDrawer.computeShadowOffset(this.mZ, this.mScale);
        float x = center.x + offset;
        float y = center.y - offset;
        float w = 0.05f * (float)region.getRegionWidth();
        float h = 0.05f * (float)region.getRegionHeight();
        float old = this.mBatch.getPackedColor();
        this.mBatch.setColor(0.0f, 0.0f, 0.0f, 0.35f);
        this.mBatch.draw(region, x - w / 2.0f, y - h / 2.0f, w / 2.0f, h / 2.0f, w, h, 1.0f, 1.0f, angle);
        this.mBatch.setPackedColor(old);
    }

    public static float computeShadowOffset(float z, float scale) {
        return (3.0f + z * 30.0f + (scale - 1.0f) * 30.0f) * 0.05f;
    }
}

