/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;

public class AnimatedImage
extends Image {
    private Animation<TextureRegion> mAnimation;
    private float mTime = 0.0f;
    private final TextureRegionDrawable mDrawable = new TextureRegionDrawable();

    public AnimatedImage(Animation<TextureRegion> animation) {
        this.setAnimation(animation);
    }

    public AnimatedImage() {
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.mAnimation == null) {
            return;
        }
        this.mTime += delta;
        TextureRegion region = this.mAnimation.getKeyFrame(this.mTime, true);
        this.mDrawable.setRegion(region);
    }

    public void setAnimation(Animation<TextureRegion> animation) {
        this.mAnimation = animation;
        this.setDrawable(this.mDrawable);
        this.mDrawable.setRegion(this.mAnimation.getKeyFrame(0.0f));
        this.pack();
        this.mTime = 0.0f;
    }

    public void setStartTime(float time) {
        this.mTime = time;
    }
}

