/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.agateau.ui.DefaultKeys;
import com.agateau.ui.InputMapper;
import com.agateau.ui.VirtualKey;
import com.agateau.utils.CollectionUtils;
import com.agateau.utils.PlatformUtils;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Preferences;
import java.util.HashMap;

public class KeyMapper
implements InputMapper {
    private final HashMap<VirtualKey, Integer[]> mKeysForVirtualKey = new HashMap();

    public static KeyMapper createUiInstance() {
        KeyMapper mapper = new KeyMapper();
        mapper.setKey(VirtualKey.LEFT, 21);
        mapper.setKey(VirtualKey.RIGHT, 22);
        mapper.setKey(VirtualKey.UP, 19);
        mapper.setKey(VirtualKey.DOWN, 20);
        mapper.setKey(VirtualKey.TRIGGER, 62);
        mapper.setKey(VirtualKey.BACK, 111);
        mapper.setKey(VirtualKey.PAUSE, 111);
        mapper.setKey(VirtualKey.SCREENSHOT, 139);
        mapper.addKey(VirtualKey.TRIGGER, 66);
        if (!PlatformUtils.isDesktop()) {
            mapper.addKey(VirtualKey.TRIGGER, 23);
            mapper.addKey(VirtualKey.BACK, 4);
        }
        return mapper;
    }

    public static KeyMapper createGameInstance(int playerIdx) {
        KeyMapper mapper = new KeyMapper();
        for (VirtualKey vkey : VirtualKey.values()) {
            int key = DefaultKeys.getDefaultKey(playerIdx, vkey);
            mapper.mKeysForVirtualKey.put(vkey, new Integer[]{key});
        }
        return mapper;
    }

    private KeyMapper() {
    }

    public void setKey(VirtualKey vkey, int key) {
        this.mKeysForVirtualKey.put(vkey, new Integer[]{key});
    }

    public void addKey(VirtualKey vkey, int key) {
        Integer[] keys = this.mKeysForVirtualKey.get((Object)vkey);
        keys = keys == null ? new Integer[]{key} : CollectionUtils.addToIntegerArray(keys, key);
        this.mKeysForVirtualKey.put(vkey, keys);
    }

    public int getKey(VirtualKey virtualKey) {
        return this.mKeysForVirtualKey.get((Object)virtualKey)[0];
    }

    @Override
    public boolean isKeyPressed(VirtualKey vkey) {
        Integer[] keys;
        for (Integer key : keys = this.mKeysForVirtualKey.get((Object)vkey)) {
            if (!Gdx.input.isKeyPressed(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isKeyJustPressed(VirtualKey vkey) {
        Integer[] keys;
        for (Integer key : keys = this.mKeysForVirtualKey.get((Object)vkey)) {
            if (!Gdx.input.isKeyJustPressed(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadConfig(Preferences preferences, String prefix, int playerIdx) {
        for (VirtualKey vkey : VirtualKey.values()) {
            String preferenceKey = prefix + vkey.toString().toLowerCase();
            int defaultValue = DefaultKeys.getDefaultKey(playerIdx, vkey);
            int key = preferences.getInteger(preferenceKey, defaultValue);
            this.mKeysForVirtualKey.put(vkey, new Integer[]{key});
        }
    }

    @Override
    public void saveConfig(Preferences preferences, String prefix) {
        for (VirtualKey vkey : VirtualKey.values()) {
            String preferenceKey = prefix + vkey.toString().toLowerCase();
            int value = this.getKey(vkey);
            preferences.putInteger(preferenceKey, value);
        }
    }

    @Override
    public boolean isAvailable() {
        return Gdx.input.isPeripheralAvailable(Input.Peripheral.HardwareKeyboard);
    }
}

