/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.anchor;

import com.agateau.ui.anchor.Anchor;
import com.agateau.ui.anchor.AnchorRule;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;

public class PositionRule
implements AnchorRule {
    public Actor target;
    public Anchor targetAnchor;
    public Actor reference;
    public Anchor referenceAnchor;
    public float hSpace;
    public float vSpace;

    @Override
    public Actor getTarget() {
        return this.target;
    }

    @Override
    public void apply() {
        Vector2 referenceOffset = new Vector2(this.reference.getWidth() * this.referenceAnchor.hPercent, this.reference.getHeight() * this.referenceAnchor.vPercent);
        Vector2 stagePos = this.reference.localToStageCoordinates(referenceOffset);
        stagePos.add(this.hSpace, this.vSpace);
        Group targetParent = this.target.getParent();
        if (targetParent == null) {
            return;
        }
        Vector2 targetPos = targetParent.stageToLocalCoordinates(stagePos);
        targetPos.add(-this.target.getWidth() * this.target.getScaleX() * this.targetAnchor.hPercent, -this.target.getHeight() * this.target.getScaleY() * this.targetAnchor.vPercent);
        this.target.setPosition(MathUtils.floor(targetPos.x), MathUtils.floor(targetPos.y));
    }
}

