/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.menu;

import com.agateau.ui.InputMapper;
import com.agateau.ui.UiInputMapper;
import com.agateau.ui.VirtualKey;

public class MenuInputHandler {
    private static final float REPEAT_DELAY = 0.6f;
    private static final float REPEAT_RATE = 0.025f;
    private InputMapper mInputMapper = UiInputMapper.getInstance();
    private State mState = State.STARTING;
    private VirtualKey mPressedVirtualKey = null;
    private VirtualKey mJustPressedVirtualKey = null;
    private float mRepeatDelay = 0.0f;

    public boolean isPressed(VirtualKey vkey) {
        return this.mPressedVirtualKey == vkey && this.mRepeatDelay < 0.0f;
    }

    public boolean isJustPressed(VirtualKey vkey) {
        return this.mJustPressedVirtualKey == vkey;
    }

    public void act(float delta) {
        if (this.mState == State.STARTING) {
            if (this.findPressedKey() == null) {
                this.mState = State.NORMAL;
            }
        } else if (this.mState == State.NORMAL) {
            this.mJustPressedVirtualKey = null;
            VirtualKey virtualKey = this.findPressedKey();
            if (virtualKey != null) {
                this.mPressedVirtualKey = virtualKey;
                this.mRepeatDelay = -1.0f;
                this.mState = State.KEY_DOWN;
            }
        } else if (this.mInputMapper.isKeyPressed(this.mPressedVirtualKey)) {
            if (this.mRepeatDelay > 0.0f) {
                this.mRepeatDelay -= delta;
            } else if (this.mState == State.KEY_DOWN) {
                this.mRepeatDelay = 0.6f;
                this.mState = State.REPEATING;
            } else {
                this.mRepeatDelay = 0.025f;
            }
        } else {
            this.mState = State.NORMAL;
            this.mJustPressedVirtualKey = this.mPressedVirtualKey;
        }
    }

    public InputMapper getInputMapper() {
        return this.mInputMapper;
    }

    public void setInputMapper(InputMapper inputMapper) {
        this.mInputMapper = inputMapper;
    }

    private VirtualKey findPressedKey() {
        for (VirtualKey virtualKey : VirtualKey.values()) {
            if (!this.mInputMapper.isKeyPressed(virtualKey)) continue;
            return virtualKey;
        }
        return null;
    }

    private static enum State {
        STARTING,
        NORMAL,
        KEY_DOWN,
        REPEATING;

    }
}

