/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.menu;

import com.agateau.ui.menu.ButtonMenuItem;
import com.agateau.ui.menu.CornerMenuItem;
import com.agateau.ui.menu.LabelMenuItem;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItem;
import com.agateau.ui.menu.SpacerMenuItem;
import com.agateau.utils.Assert;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.Array;
import java.util.HashMap;

public class MenuItemGroup
implements MenuItem {
    private final Menu mMenu;
    private final WidgetGroup mGroup = new WidgetGroup(){

        @Override
        public void layout() {
            MenuItemGroup.this.layoutItems();
        }
    };
    private final Array<MenuItem> mItems = new Array();
    private final HashMap<Actor, MenuItem> mItemForActor = new HashMap();
    private final HashMap<MenuItem, ItemInfo> mInfoForItem = new HashMap();
    private int mCurrentIndex = -1;
    private float mWidth = -1.0f;
    private final Rectangle mFocusRect = new Rectangle();
    private final Rectangle mActorRectangle = new Rectangle();

    public MenuItemGroup(final Menu menu) {
        this.mMenu = menu;
        this.mGroup.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                MenuItem item = MenuItemGroup.this.getItemAt(x, y);
                if (item != null && item.isFocusable()) {
                    MenuItemGroup.this.setCurrentItem(item);
                }
                return false;
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                menu.setCurrentItem(MenuItemGroup.this);
            }
        });
    }

    public void setWidth(float width) {
        this.mWidth = width;
        this.mGroup.setWidth(width);
        this.updateHeight();
    }

    public void focusFirstItem() {
        for (MenuItem item : this.mItems) {
            if (!item.isFocusable()) continue;
            this.setCurrentItem(item);
            return;
        }
    }

    public void updateFocusIndicatorBounds() {
        this.getCurrentItem().setFocused(true);
    }

    public MenuItemGroup findItemParentGroup(MenuItem wanted) {
        for (MenuItem item : this.mItems) {
            MenuItemGroup group;
            if (item == wanted) {
                return this;
            }
            if (!(item instanceof MenuItemGroup) || (group = ((MenuItemGroup)item).findItemParentGroup(wanted)) == null) continue;
            return group;
        }
        return null;
    }

    @Override
    public Actor getActor() {
        return this.mGroup;
    }

    @Override
    public boolean addListener(EventListener eventListener) {
        return this.mGroup.addListener(eventListener);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused) {
            this.adjustIndex(-1, 1);
        } else {
            this.setCurrentIndex(-1);
        }
    }

    @Override
    public void trigger() {
        MenuItem item = this.getCurrentItem();
        if (item == null) {
            return;
        }
        Assert.check(this.isItemVisible(item), "Cannot trigger an invisible item", new Object[0]);
        item.trigger();
    }

    @Override
    public boolean goDown() {
        if (this.getCurrentItem() != null && this.getCurrentItem().goDown()) {
            return true;
        }
        return this.adjustIndex(this.mCurrentIndex, 1);
    }

    @Override
    public boolean goUp() {
        if (this.getCurrentItem() != null && this.getCurrentItem().goUp()) {
            return true;
        }
        return this.adjustIndex(this.mCurrentIndex, -1);
    }

    @Override
    public void goLeft() {
        MenuItem item = this.getCurrentItem();
        if (item != null) {
            if (item instanceof CornerMenuItem) {
                this.goUp();
            } else {
                item.goLeft();
            }
        }
    }

    @Override
    public void goRight() {
        MenuItem item = this.getCurrentItem();
        if (item != null) {
            if (item instanceof CornerMenuItem) {
                this.goDown();
            } else {
                item.goRight();
            }
        }
    }

    @Override
    public Rectangle getFocusRectangle() {
        MenuItem item = this.getCurrentItem();
        Assert.check(item != null, "Cannot get focus rectangle of an invalid item", new Object[0]);
        Assert.check(item.isFocusable(), "Item " + item + " is not focusable", new Object[0]);
        this.mFocusRect.set(item.getFocusRectangle());
        Actor actor = item.getActor();
        this.mFocusRect.x += actor.getX();
        this.mFocusRect.y += actor.getY();
        return this.mFocusRect;
    }

    @Override
    public float getParentWidthRatio() {
        return this.mWidth == -1.0f ? 1.0f : 0.0f;
    }

    public MenuItem getCurrentItem() {
        return this.mCurrentIndex >= 0 ? this.mItems.get(this.mCurrentIndex) : null;
    }

    public void setCurrentItem(MenuItem item) {
        int index;
        if (item == null) {
            this.setCurrentIndex(-1);
            return;
        }
        if (this.getCurrentItem() instanceof MenuItemGroup) {
            ((MenuItemGroup)this.getCurrentItem()).setCurrentItem(item);
        }
        if ((index = this.getItemIndex(item)) == -1) {
            return;
        }
        this.setCurrentIndex(index);
    }

    public boolean isItemVisible(MenuItem item) {
        ItemInfo info = this.mInfoForItem.get(item);
        Assert.check(info != null, "No info for item", new Object[0]);
        return info.visible;
    }

    public void setItemVisible(MenuItem item, boolean visible) {
        if (this.isItemVisible(item) == visible) {
            return;
        }
        ItemInfo info = this.mInfoForItem.get(item);
        info.visible = visible;
        item.getActor().setVisible(visible);
        if (info.labelActor != null) {
            info.labelActor.setVisible(visible);
        }
        this.updateHeight();
    }

    public ButtonMenuItem addButton(String text) {
        ButtonMenuItem item = new ButtonMenuItem(this.mMenu, text, this.mMenu.getSkin());
        this.addItem(item);
        return item;
    }

    public LabelMenuItem addLabel(String text) {
        LabelMenuItem labelMenuItem = new LabelMenuItem(text, this.mMenu.getSkin());
        this.addItem(labelMenuItem);
        return labelMenuItem;
    }

    public LabelMenuItem addTitleLabel(String text) {
        LabelMenuItem labelMenuItem = new LabelMenuItem(text, this.mMenu.getSkin(), "menuTitle");
        this.addItem(labelMenuItem);
        return labelMenuItem;
    }

    public MenuItem addItem(MenuItem item) {
        this.addItemInternal(item, null);
        return item;
    }

    public SpacerMenuItem addSpacer() {
        SpacerMenuItem item = new SpacerMenuItem(this.mMenu.getMenuStyle().spacing);
        this.addItem(item);
        return item;
    }

    public MenuItem addItemWithLabel(String labelText, MenuItem item) {
        return this.addItemWithLabel(labelText, item, "default");
    }

    public MenuItem addItemWithLabel(String labelText, MenuItem item, String labelStyle) {
        Label label = new Label(labelText, this.mMenu.getSkin(), labelStyle);
        return this.addItemWithLabelActor(label, item);
    }

    public MenuItem addItemWithLabelActor(Actor labelActor, MenuItem item) {
        Actor actor = item.getActor();
        float height = actor.getHeight();
        float labelWidth = this.mMenu.getLabelColumnWidth();
        labelActor.setSize(labelWidth, height);
        this.addItemInternal(item, labelActor);
        return item;
    }

    private boolean adjustIndex(int startIndex, int delta) {
        int size = this.mItems.size;
        for (int idx = startIndex + delta; idx >= 0 && idx < size; idx += delta) {
            MenuItem item = this.mItems.get(idx);
            if (!item.isFocusable() || !this.isItemVisible(item)) continue;
            this.setCurrentIndex(idx, delta > 0 ? SetCurrentHint.FROM_TOP : SetCurrentHint.FROM_BOTTOM);
            return true;
        }
        return false;
    }

    private void layoutCornerMenuItem(CornerMenuItem item, float spacing) {
        Actor actor = item.getActor();
        float screenW = actor.getStage().getWidth();
        float x = item.getCorner() == CornerMenuItem.Corner.BOTTOM_LEFT ? spacing : screenW - actor.getWidth() - spacing;
        actor.setPosition(x, spacing);
    }

    private void layoutItems() {
        float y = 0.0f;
        Menu.MenuStyle style = this.mMenu.getMenuStyle();
        float spacing = style.focusPadding * 2 + style.spacing;
        for (int idx = this.mItems.size - 1; idx >= 0; --idx) {
            float ratio;
            MenuItem item = this.mItems.get(idx);
            if (item instanceof CornerMenuItem) {
                this.layoutCornerMenuItem((CornerMenuItem)item, spacing);
                continue;
            }
            ItemInfo info = this.mInfoForItem.get(item);
            if (!info.visible) continue;
            Actor actor = item.getActor();
            float x = 0.0f;
            float width = this.mGroup.getWidth();
            if (info.labelActor != null) {
                info.labelActor.setPosition(0.0f, y);
                x = this.mMenu.getLabelColumnWidth();
                width -= x;
            }
            if ((ratio = this.mItemForActor.get(actor).getParentWidthRatio()) > 0.0f) {
                actor.setWidth(width * ratio);
            }
            if (info.labelActor == null) {
                x += (width - actor.getWidth()) / 2.0f;
            }
            actor.setPosition(x, y);
            y += actor.getHeight() + spacing;
        }
    }

    private void addItemInternal(MenuItem item, Actor labelActor) {
        this.mItems.add(item);
        ItemInfo info = new ItemInfo();
        info.labelActor = labelActor;
        this.mInfoForItem.put(item, info);
        this.mItemForActor.put(item.getActor(), item);
        if (labelActor != null) {
            this.mGroup.addActor(labelActor);
        }
        if (item instanceof CornerMenuItem) {
            this.mGroup.getStage().getRoot().addActor(item.getActor());
        } else {
            this.mGroup.addActor(item.getActor());
            this.updateHeight();
        }
    }

    private void updateHeight() {
        float y = 0.0f;
        Menu.MenuStyle style = this.mMenu.getMenuStyle();
        float spacing = style.focusPadding * 2 + style.spacing;
        for (int idx = this.mItems.size - 1; idx >= 0; --idx) {
            float ratio;
            MenuItem item = this.mItems.get(idx);
            if (item instanceof CornerMenuItem) continue;
            ItemInfo info = this.mInfoForItem.get(item);
            if (!info.visible) continue;
            Actor actor = item.getActor();
            float width = this.mGroup.getWidth();
            if (info.labelActor != null) {
                width -= this.mMenu.getLabelColumnWidth();
            }
            if ((ratio = this.mItemForActor.get(actor).getParentWidthRatio()) > 0.0f) {
                actor.setWidth(width * ratio);
            }
            if (actor instanceof Widget) {
                ((Widget)actor).pack();
            }
            y += actor.getHeight() + spacing;
        }
        this.mGroup.setHeight(y - spacing);
        this.mMenu.onGroupBoundariesChanged();
    }

    private void setCurrentIndex(int index) {
        this.setCurrentIndex(index, SetCurrentHint.NONE);
    }

    private void setCurrentIndex(int index, SetCurrentHint hint) {
        MenuItem item;
        if (this.mCurrentIndex == index) {
            return;
        }
        if (this.mCurrentIndex != -1 && (item = this.getCurrentItem()).isFocusable()) {
            item.setFocused(false);
        }
        this.mCurrentIndex = index;
        if (this.mCurrentIndex != -1) {
            item = this.getCurrentItem();
            Assert.check(this.isItemVisible(item), "Cannot set an invisible item current", new Object[0]);
            Assert.check(item.isFocusable(), "Item " + item + " is not focusable", new Object[0]);
            item.setFocused(true);
            if (item instanceof MenuItemGroup) {
                MenuItemGroup group = (MenuItemGroup)item;
                switch (hint) {
                    case NONE: {
                        break;
                    }
                    case FROM_TOP: {
                        group.adjustIndex(-1, 1);
                        break;
                    }
                    case FROM_BOTTOM: {
                        group.adjustIndex(group.mItems.size, -1);
                    }
                }
            }
        }
    }

    private MenuItem getItemAt(float x, float y) {
        for (MenuItem item : this.mItems) {
            Actor actor;
            if (!this.isItemVisible(item)) continue;
            this.mActorRectangle.set(0.0f, 0.0f, actor.getWidth(), actor.getHeight());
            for (actor = item.getActor(); actor != this.mGroup && actor != null; actor = actor.getParent()) {
                this.mActorRectangle.x += actor.getX();
                this.mActorRectangle.y += actor.getY();
            }
            if (!this.mActorRectangle.contains(x, y)) continue;
            return item;
        }
        return null;
    }

    private int getItemIndex(MenuItem item) {
        return this.mItems.indexOf(item, true);
    }

    private static class ItemInfo {
        Actor labelActor = null;
        boolean visible = true;

        private ItemInfo() {
        }
    }

    private static enum SetCurrentHint {
        NONE,
        FROM_TOP,
        FROM_BOTTOM;

    }
}

