/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SpinnerUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.DocumentFilter;
import javax.swing.text.NumberFormatter;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;

public class JSpinner
extends JComponent
implements Accessible {
    private static final String uiClassID = "SpinnerUI";
    private static final Action DISABLED_ACTION = new DisabledAction();
    private SpinnerModel model;
    private JComponent editor;
    private ChangeListener modelListener;
    private transient ChangeEvent changeEvent;
    private boolean editorExplicitlySet = false;

    public JSpinner(SpinnerModel spinnerModel) {
        if (spinnerModel == null) {
            throw new NullPointerException("model cannot be null");
        }
        this.model = spinnerModel;
        this.editor = this.createEditor(spinnerModel);
        this.setUIProperty("opaque", true);
        this.updateUI();
    }

    public JSpinner() {
        this(new SpinnerNumberModel());
    }

    public SpinnerUI getUI() {
        return (SpinnerUI)this.ui;
    }

    public void setUI(SpinnerUI spinnerUI) {
        super.setUI(spinnerUI);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI((SpinnerUI)UIManager.getUI(this));
        this.invalidate();
    }

    protected JComponent createEditor(SpinnerModel spinnerModel) {
        if (spinnerModel instanceof SpinnerDateModel) {
            return new DateEditor(this);
        }
        if (spinnerModel instanceof SpinnerListModel) {
            return new ListEditor(this);
        }
        if (spinnerModel instanceof SpinnerNumberModel) {
            return new NumberEditor(this);
        }
        return new DefaultEditor(this);
    }

    public void setModel(SpinnerModel spinnerModel) {
        if (spinnerModel == null) {
            throw new IllegalArgumentException("null model");
        }
        if (!spinnerModel.equals(this.model)) {
            SpinnerModel spinnerModel2 = this.model;
            this.model = spinnerModel;
            if (this.modelListener != null) {
                spinnerModel2.removeChangeListener(this.modelListener);
                this.model.addChangeListener(this.modelListener);
            }
            this.firePropertyChange("model", spinnerModel2, spinnerModel);
            if (!this.editorExplicitlySet) {
                this.setEditor(this.createEditor(spinnerModel));
                this.editorExplicitlySet = false;
            }
            this.repaint();
            this.revalidate();
        }
    }

    public SpinnerModel getModel() {
        return this.model;
    }

    public Object getValue() {
        return this.getModel().getValue();
    }

    public void setValue(Object object) {
        this.getModel().setValue(object);
    }

    public Object getNextValue() {
        return this.getModel().getNextValue();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.modelListener == null) {
            this.modelListener = new ModelListener();
            this.getModel().addChangeListener(this.modelListener);
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public Object getPreviousValue() {
        return this.getModel().getPreviousValue();
    }

    public void setEditor(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("null editor");
        }
        if (!jComponent.equals(this.editor)) {
            JComponent jComponent2 = this.editor;
            this.editor = jComponent;
            if (jComponent2 instanceof DefaultEditor) {
                ((DefaultEditor)jComponent2).dismiss(this);
            }
            this.editorExplicitlySet = true;
            this.firePropertyChange("editor", jComponent2, jComponent);
            this.revalidate();
            this.repaint();
        }
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public void commitEdit() throws ParseException {
        JComponent jComponent = this.getEditor();
        if (jComponent instanceof DefaultEditor) {
            ((DefaultEditor)jComponent).commitEdit();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSpinner();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJSpinner
    extends JComponent.AccessibleJComponent
    implements AccessibleValue,
    AccessibleAction,
    AccessibleText,
    AccessibleEditableText,
    ChangeListener {
        private Object oldModelValue = null;

        protected AccessibleJSpinner() {
            this.oldModelValue = JSpinner.this.model.getValue();
            JSpinner.this.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent == null) {
                throw new NullPointerException();
            }
            Object object = JSpinner.this.model.getValue();
            this.firePropertyChange("AccessibleValue", this.oldModelValue, object);
            this.firePropertyChange("AccessibleText", null, 0);
            this.oldModelValue = object;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPIN_BOX;
        }

        @Override
        public int getAccessibleChildrenCount() {
            if (JSpinner.this.editor.getAccessibleContext() != null) {
                return 1;
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (n != 0) {
                return null;
            }
            if (JSpinner.this.editor.getAccessibleContext() != null) {
                return (Accessible)((Object)JSpinner.this.editor);
            }
            return null;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public AccessibleText getAccessibleText() {
            return this;
        }

        private AccessibleContext getEditorAccessibleContext() {
            if (JSpinner.this.editor instanceof DefaultEditor) {
                JFormattedTextField jFormattedTextField = ((DefaultEditor)JSpinner.this.editor).getTextField();
                if (jFormattedTextField != null) {
                    return jFormattedTextField.getAccessibleContext();
                }
            } else if (JSpinner.this.editor instanceof Accessible) {
                return JSpinner.this.editor.getAccessibleContext();
            }
            return null;
        }

        private AccessibleText getEditorAccessibleText() {
            AccessibleContext accessibleContext = this.getEditorAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleText();
            }
            return null;
        }

        private AccessibleEditableText getEditorAccessibleEditableText() {
            AccessibleText accessibleText = this.getEditorAccessibleText();
            if (accessibleText instanceof AccessibleEditableText) {
                return (AccessibleEditableText)accessibleText;
            }
            return null;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            Object object = JSpinner.this.model.getValue();
            if (object instanceof Number) {
                return (Number)object;
            }
            return null;
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            try {
                JSpinner.this.model.setValue(number);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        @Override
        public Number getMinimumAccessibleValue() {
            SpinnerNumberModel spinnerNumberModel;
            Comparable comparable;
            if (JSpinner.this.model instanceof SpinnerNumberModel && (comparable = (spinnerNumberModel = (SpinnerNumberModel)JSpinner.this.model).getMinimum()) instanceof Number) {
                return (Number)((Object)comparable);
            }
            return null;
        }

        @Override
        public Number getMaximumAccessibleValue() {
            SpinnerNumberModel spinnerNumberModel;
            Comparable comparable;
            if (JSpinner.this.model instanceof SpinnerNumberModel && (comparable = (spinnerNumberModel = (SpinnerNumberModel)JSpinner.this.model).getMaximum()) instanceof Number) {
                return (Number)((Object)comparable);
            }
            return null;
        }

        @Override
        public int getAccessibleActionCount() {
            return 2;
        }

        @Override
        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return AccessibleAction.INCREMENT;
            }
            if (n == 1) {
                return AccessibleAction.DECREMENT;
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int n) {
            if (n < 0 || n > 1) {
                return false;
            }
            Object object = n == 0 ? JSpinner.this.getNextValue() : JSpinner.this.getPreviousValue();
            try {
                JSpinner.this.model.setValue(object);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        private boolean sameWindowAncestor(Component component, Component component2) {
            if (component == null || component2 == null) {
                return false;
            }
            return SwingUtilities.getWindowAncestor(component) == SwingUtilities.getWindowAncestor(component2);
        }

        @Override
        public int getIndexAtPoint(Point point) {
            Point point2;
            AccessibleText accessibleText = this.getEditorAccessibleText();
            if (accessibleText != null && this.sameWindowAncestor(JSpinner.this, JSpinner.this.editor) && (point2 = SwingUtilities.convertPoint(JSpinner.this, point, JSpinner.this.editor)) != null) {
                return accessibleText.getIndexAtPoint(point2);
            }
            return -1;
        }

        @Override
        public Rectangle getCharacterBounds(int n) {
            Rectangle rectangle;
            AccessibleText accessibleText = this.getEditorAccessibleText();
            if (accessibleText != null && (rectangle = accessibleText.getCharacterBounds(n)) != null && this.sameWindowAncestor(JSpinner.this, JSpinner.this.editor)) {
                return SwingUtilities.convertRectangle(JSpinner.this.editor, rectangle, JSpinner.this);
            }
            return null;
        }

        @Override
        public int getCharCount() {
            AccessibleText accessibleText = this.getEditorAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getCharCount();
            }
            return -1;
        }

        @Override
        public int getCaretPosition() {
            AccessibleText accessibleText = this.getEditorAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getCaretPosition();
            }
            return -1;
        }

        @Override
        public String getAtIndex(int n, int n2) {
            AccessibleText accessibleText = this.getEditorAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getAtIndex(n, n2);
            }
            return null;
        }

        @Override
        public String getAfterIndex(int n, int n2) {
            AccessibleText accessibleText = this.getEditorAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getAfterIndex(n, n2);
            }
            return null;
        }

        @Override
        public String getBeforeIndex(int n, int n2) {
            AccessibleText accessibleText = this.getEditorAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getBeforeIndex(n, n2);
            }
            return null;
        }

        @Override
        public AttributeSet getCharacterAttribute(int n) {
            AccessibleText accessibleText = this.getEditorAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getCharacterAttribute(n);
            }
            return null;
        }

        @Override
        public int getSelectionStart() {
            AccessibleText accessibleText = this.getEditorAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getSelectionStart();
            }
            return -1;
        }

        @Override
        public int getSelectionEnd() {
            AccessibleText accessibleText = this.getEditorAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getSelectionEnd();
            }
            return -1;
        }

        @Override
        public String getSelectedText() {
            AccessibleText accessibleText = this.getEditorAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getSelectedText();
            }
            return null;
        }

        @Override
        public void setTextContents(String string) {
            AccessibleEditableText accessibleEditableText = this.getEditorAccessibleEditableText();
            if (accessibleEditableText != null) {
                accessibleEditableText.setTextContents(string);
            }
        }

        @Override
        public void insertTextAtIndex(int n, String string) {
            AccessibleEditableText accessibleEditableText = this.getEditorAccessibleEditableText();
            if (accessibleEditableText != null) {
                accessibleEditableText.insertTextAtIndex(n, string);
            }
        }

        @Override
        public String getTextRange(int n, int n2) {
            AccessibleEditableText accessibleEditableText = this.getEditorAccessibleEditableText();
            if (accessibleEditableText != null) {
                return accessibleEditableText.getTextRange(n, n2);
            }
            return null;
        }

        @Override
        public void delete(int n, int n2) {
            AccessibleEditableText accessibleEditableText = this.getEditorAccessibleEditableText();
            if (accessibleEditableText != null) {
                accessibleEditableText.delete(n, n2);
            }
        }

        @Override
        public void cut(int n, int n2) {
            AccessibleEditableText accessibleEditableText = this.getEditorAccessibleEditableText();
            if (accessibleEditableText != null) {
                accessibleEditableText.cut(n, n2);
            }
        }

        @Override
        public void paste(int n) {
            AccessibleEditableText accessibleEditableText = this.getEditorAccessibleEditableText();
            if (accessibleEditableText != null) {
                accessibleEditableText.paste(n);
            }
        }

        @Override
        public void replaceText(int n, int n2, String string) {
            AccessibleEditableText accessibleEditableText = this.getEditorAccessibleEditableText();
            if (accessibleEditableText != null) {
                accessibleEditableText.replaceText(n, n2, string);
            }
        }

        @Override
        public void selectText(int n, int n2) {
            AccessibleEditableText accessibleEditableText = this.getEditorAccessibleEditableText();
            if (accessibleEditableText != null) {
                accessibleEditableText.selectText(n, n2);
            }
        }

        @Override
        public void setAttributes(int n, int n2, AttributeSet attributeSet) {
            AccessibleEditableText accessibleEditableText = this.getEditorAccessibleEditableText();
            if (accessibleEditableText != null) {
                accessibleEditableText.setAttributes(n, n2, attributeSet);
            }
        }
    }

    private static class DisabledAction
    implements Action {
        private DisabledAction() {
        }

        @Override
        public Object getValue(String string) {
            return null;
        }

        @Override
        public void putValue(String string, Object object) {
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class ListEditor
    extends DefaultEditor {
        public ListEditor(JSpinner jSpinner) {
            super(jSpinner);
            if (!(jSpinner.getModel() instanceof SpinnerListModel)) {
                throw new IllegalArgumentException("model not a SpinnerListModel");
            }
            this.getTextField().setEditable(true);
            this.getTextField().setFormatterFactory(new DefaultFormatterFactory(new ListFormatter()));
        }

        public SpinnerListModel getModel() {
            return (SpinnerListModel)this.getSpinner().getModel();
        }

        private class ListFormatter
        extends JFormattedTextField.AbstractFormatter {
            private DocumentFilter filter;

            private ListFormatter() {
            }

            @Override
            public String valueToString(Object object) throws ParseException {
                if (object == null) {
                    return "";
                }
                return object.toString();
            }

            @Override
            public Object stringToValue(String string) throws ParseException {
                return string;
            }

            @Override
            protected DocumentFilter getDocumentFilter() {
                if (this.filter == null) {
                    this.filter = new Filter();
                }
                return this.filter;
            }

            private class Filter
            extends DocumentFilter {
                private Filter() {
                }

                @Override
                public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (string != null && n + n2 == filterBypass.getDocument().getLength()) {
                        String string2;
                        Object object = ListEditor.this.getModel().findNextMatch(filterBypass.getDocument().getText(0, n) + string);
                        String string3 = string2 = object != null ? object.toString() : null;
                        if (string2 != null) {
                            filterBypass.remove(0, n + n2);
                            filterBypass.insertString(0, string2, null);
                            ListFormatter.this.getFormattedTextField().select(n + string.length(), string2.length());
                            return;
                        }
                    }
                    super.replace(filterBypass, n, n2, string, attributeSet);
                }

                @Override
                public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    this.replace(filterBypass, n, 0, string, attributeSet);
                }
            }
        }
    }

    public static class NumberEditor
    extends DefaultEditor {
        private static String getDefaultPattern(Locale locale) {
            LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(NumberFormatProvider.class, locale);
            LocaleResources localeResources = localeProviderAdapter.getLocaleResources(locale);
            if (localeResources == null) {
                localeResources = LocaleProviderAdapter.forJRE().getLocaleResources(locale);
            }
            String[] stringArray = localeResources.getNumberPatterns();
            return stringArray[0];
        }

        public NumberEditor(JSpinner jSpinner) {
            this(jSpinner, NumberEditor.getDefaultPattern(jSpinner.getLocale()));
        }

        public NumberEditor(JSpinner jSpinner, String string) {
            this(jSpinner, new DecimalFormat(string));
        }

        private NumberEditor(JSpinner jSpinner, DecimalFormat decimalFormat) {
            super(jSpinner);
            if (!(jSpinner.getModel() instanceof SpinnerNumberModel)) {
                throw new IllegalArgumentException("model not a SpinnerNumberModel");
            }
            SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)jSpinner.getModel();
            NumberEditorFormatter numberEditorFormatter = new NumberEditorFormatter(spinnerNumberModel, decimalFormat);
            DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(numberEditorFormatter);
            JFormattedTextField jFormattedTextField = this.getTextField();
            jFormattedTextField.setEditable(true);
            jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
            jFormattedTextField.setHorizontalAlignment(4);
            try {
                String string = numberEditorFormatter.valueToString(spinnerNumberModel.getMinimum());
                String string2 = numberEditorFormatter.valueToString(spinnerNumberModel.getMaximum());
                jFormattedTextField.setColumns(Math.max(string.length(), string2.length()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public DecimalFormat getFormat() {
            return (DecimalFormat)((NumberFormatter)this.getTextField().getFormatter()).getFormat();
        }

        public SpinnerNumberModel getModel() {
            return (SpinnerNumberModel)this.getSpinner().getModel();
        }

        @Override
        public void setComponentOrientation(ComponentOrientation componentOrientation) {
            super.setComponentOrientation(componentOrientation);
            this.getTextField().setHorizontalAlignment(componentOrientation.isLeftToRight() ? 4 : 2);
        }
    }

    private static class NumberEditorFormatter
    extends NumberFormatter {
        private final SpinnerNumberModel model;

        NumberEditorFormatter(SpinnerNumberModel spinnerNumberModel, NumberFormat numberFormat) {
            super(numberFormat);
            this.model = spinnerNumberModel;
            this.setValueClass(spinnerNumberModel.getValue().getClass());
        }

        @Override
        public void setMinimum(Comparable comparable) {
            this.model.setMinimum(comparable);
        }

        @Override
        public Comparable getMinimum() {
            return this.model.getMinimum();
        }

        @Override
        public void setMaximum(Comparable comparable) {
            this.model.setMaximum(comparable);
        }

        @Override
        public Comparable getMaximum() {
            return this.model.getMaximum();
        }
    }

    public static class DateEditor
    extends DefaultEditor {
        private static String getDefaultPattern(Locale locale) {
            LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(DateFormatProvider.class, locale);
            LocaleResources localeResources = localeProviderAdapter.getLocaleResources(locale);
            if (localeResources == null) {
                localeResources = LocaleProviderAdapter.forJRE().getLocaleResources(locale);
            }
            return localeResources.getDateTimePattern(3, 3, null);
        }

        public DateEditor(JSpinner jSpinner) {
            this(jSpinner, DateEditor.getDefaultPattern(jSpinner.getLocale()));
        }

        public DateEditor(JSpinner jSpinner, String string) {
            this(jSpinner, new SimpleDateFormat(string, jSpinner.getLocale()));
        }

        private DateEditor(JSpinner jSpinner, DateFormat dateFormat) {
            super(jSpinner);
            if (!(jSpinner.getModel() instanceof SpinnerDateModel)) {
                throw new IllegalArgumentException("model not a SpinnerDateModel");
            }
            SpinnerDateModel spinnerDateModel = (SpinnerDateModel)jSpinner.getModel();
            DateEditorFormatter dateEditorFormatter = new DateEditorFormatter(spinnerDateModel, dateFormat);
            DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(dateEditorFormatter);
            JFormattedTextField jFormattedTextField = this.getTextField();
            jFormattedTextField.setEditable(true);
            jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
            try {
                String string = dateEditorFormatter.valueToString(spinnerDateModel.getStart());
                String string2 = dateEditorFormatter.valueToString(spinnerDateModel.getEnd());
                jFormattedTextField.setColumns(Math.max(string.length(), string2.length()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public SimpleDateFormat getFormat() {
            return (SimpleDateFormat)((DateFormatter)this.getTextField().getFormatter()).getFormat();
        }

        public SpinnerDateModel getModel() {
            return (SpinnerDateModel)this.getSpinner().getModel();
        }
    }

    private static class DateEditorFormatter
    extends DateFormatter {
        private final SpinnerDateModel model;

        DateEditorFormatter(SpinnerDateModel spinnerDateModel, DateFormat dateFormat) {
            super(dateFormat);
            this.model = spinnerDateModel;
        }

        @Override
        public void setMinimum(Comparable comparable) {
            this.model.setStart(comparable);
        }

        @Override
        public Comparable getMinimum() {
            return this.model.getStart();
        }

        @Override
        public void setMaximum(Comparable comparable) {
            this.model.setEnd(comparable);
        }

        @Override
        public Comparable getMaximum() {
            return this.model.getEnd();
        }
    }

    public static class DefaultEditor
    extends JPanel
    implements ChangeListener,
    PropertyChangeListener,
    LayoutManager {
        public DefaultEditor(JSpinner jSpinner) {
            super(null);
            JFormattedTextField jFormattedTextField = new JFormattedTextField();
            jFormattedTextField.setName("Spinner.formattedTextField");
            jFormattedTextField.setValue(jSpinner.getValue());
            jFormattedTextField.addPropertyChangeListener(this);
            jFormattedTextField.setEditable(false);
            jFormattedTextField.setInheritsPopupMenu(true);
            String string = jSpinner.getToolTipText();
            if (string != null) {
                jFormattedTextField.setToolTipText(string);
            }
            this.add(jFormattedTextField);
            this.setLayout(this);
            jSpinner.addChangeListener(this);
            ActionMap actionMap = jFormattedTextField.getActionMap();
            if (actionMap != null) {
                actionMap.put("increment", DISABLED_ACTION);
                actionMap.put("decrement", DISABLED_ACTION);
            }
        }

        public void dismiss(JSpinner jSpinner) {
            jSpinner.removeChangeListener(this);
        }

        public JSpinner getSpinner() {
            for (Container container = this; container != null; container = container.getParent()) {
                if (!(container instanceof JSpinner)) continue;
                return (JSpinner)container;
            }
            return null;
        }

        public JFormattedTextField getTextField() {
            return (JFormattedTextField)this.getComponent(0);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            this.getTextField().setValue(jSpinner.getValue());
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JSpinner jSpinner = this.getSpinner();
            if (jSpinner == null) {
                return;
            }
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (object instanceof JFormattedTextField && "value".equals(string)) {
                Object object2 = jSpinner.getValue();
                try {
                    jSpinner.setValue(this.getTextField().getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        ((JFormattedTextField)object).setValue(object2);
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        private Dimension insetSize(Container container) {
            Insets insets = container.getInsets();
            int n = insets.left + insets.right;
            int n2 = insets.top + insets.bottom;
            return new Dimension(n, n2);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.insetSize(container);
            if (container.getComponentCount() > 0) {
                Dimension dimension2 = this.getComponent(0).getPreferredSize();
                dimension.width += dimension2.width;
                dimension.height += dimension2.height;
            }
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = this.insetSize(container);
            if (container.getComponentCount() > 0) {
                Dimension dimension2 = this.getComponent(0).getMinimumSize();
                dimension.width += dimension2.width;
                dimension.height += dimension2.height;
            }
            return dimension;
        }

        @Override
        public void layoutContainer(Container container) {
            if (container.getComponentCount() > 0) {
                Insets insets = container.getInsets();
                int n = container.getWidth() - (insets.left + insets.right);
                int n2 = container.getHeight() - (insets.top + insets.bottom);
                this.getComponent(0).setBounds(insets.left, insets.top, n, n2);
            }
        }

        public void commitEdit() throws ParseException {
            JFormattedTextField jFormattedTextField = this.getTextField();
            jFormattedTextField.commitEdit();
        }

        @Override
        public int getBaseline(int n, int n2) {
            super.getBaseline(n, n2);
            Insets insets = this.getInsets();
            n = n - insets.left - insets.right;
            n2 = n2 - insets.top - insets.bottom;
            int n3 = this.getComponent(0).getBaseline(n, n2);
            if (n3 >= 0) {
                return n3 + insets.top;
            }
            return -1;
        }

        @Override
        public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
            return this.getComponent(0).getBaselineResizeBehavior();
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        private ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner.this.fireStateChanged();
        }
    }
}

