/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.gamesetup.Difficulty;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.rewards.ChampionshipRankRewardRule;
import com.agateau.pixelwheels.rewards.CounterRewardRule;
import com.agateau.pixelwheels.rewards.Reward;
import com.agateau.pixelwheels.rewards.RewardManager;
import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.translations.Translator;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.utils.Array;

class RewardManagerSetup {
    private static final int UNLOCK_ROCKET_COUNT = 10;
    private static final int UNLOCK_HARVESTER_COUNT = 50;
    private static final int UNLOCK_PICKUP_COUNT = 30;
    private static final int UNLOCK_DARK_M_COUNT = 40;
    private static final int UNLOCK_JEEP_COUNT = 100;
    private static final int UNLOCK_ANTONIN_COUNT = 40;

    RewardManagerSetup() {
    }

    static void createChampionshipRules(RewardManager rewardManager, Array<Championship> championships) {
        rewardManager.addRule(Reward.get(championships.first()), RewardManager.ALWAYS_UNLOCKED);
        for (int idx = 1; idx < championships.size; ++idx) {
            Championship previous = championships.get(idx - 1);
            Championship current = championships.get(idx);
            rewardManager.addRule(Reward.get(championships.get(idx)), RewardManagerSetup.createChampionshipRule(championships, previous, current, idx));
        }
    }

    private static ChampionshipRankRewardRule createChampionshipRule(final Array<Championship> championships, final Championship previous, final Championship current, final int currentIdx) {
        return new ChampionshipRankRewardRule(previous, 2){

            @Override
            public boolean hasBeenUnlocked(GameStats gameStats) {
                if (super.hasBeenUnlocked(gameStats)) {
                    return true;
                }
                if (this.hasAlreadyRacedChampionshipOrAfter(championships, currentIdx, gameStats)) {
                    NLog.i("Unlock '%s' even if the rank on previous ('%s') is not enough, because we already raced '%s' or a championship after it in the past", current, previous, current);
                    return true;
                }
                return false;
            }

            private boolean hasAlreadyRacedChampionshipOrAfter(Array<Championship> championships2, int currentIdx2, GameStats gameStats) {
                for (int idx = currentIdx2; idx < championships2.size; ++idx) {
                    if (1.getBestBestChampionshipRank(gameStats, championships2.get(idx)) >= Integer.MAX_VALUE) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static void createVehicleRules(RewardManager rewardManager, Assets assets) {
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("rocket")), new CounterRewardRule(GameStats.Event.MISSILE_HIT, 10, Translator.trn("Hit one vehicle with a missile", "Hit %# vehicles with a missile", 10)));
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("harvester")), new CounterRewardRule(GameStats.Event.LEAVING_ROAD, 50, Translator.trn("Leave road one time", "Leave road %# times", 50)));
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("antonin")), new CounterRewardRule(GameStats.Event.ENTERING_SAND, 40, Translator.trn("Drive in the sand one time", "Drive in the sand %# times", 40)));
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("pickup")), new CounterRewardRule(GameStats.Event.PICKED_BONUS, 30, Translator.trn("Pick one bonus", "Pick %# bonuses", 30)));
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("dark-m")), new CounterRewardRule(GameStats.Event.MISSILE_HIT, 40, Translator.trn("Hit one vehicle with a missile", "Hit %# vehicles with a missile", 40)));
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("jeep")), new CounterRewardRule(GameStats.Event.LEAVING_ROAD, 100, Translator.trn("Leave road one time", "Leave road %# times", 100)));
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("2cv")), new ChampionshipRankRewardRule(Difficulty.MEDIUM, assets.findChampionshipById("country"), 0));
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("roadster")), new ChampionshipRankRewardRule(Difficulty.HARD, assets.findChampionshipById("country"), 0));
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("bigfoot")), new ChampionshipRankRewardRule(Difficulty.EASY, assets.findChampionshipById("snow"), 0));
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("c15")), new ChampionshipRankRewardRule(Difficulty.MEDIUM, assets.findChampionshipById("snow"), 0));
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("santa")), new ChampionshipRankRewardRule(Difficulty.HARD, assets.findChampionshipById("snow"), 0));
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("miramar")), new ChampionshipRankRewardRule(Difficulty.MEDIUM, assets.findChampionshipById("city"), 0));
        rewardManager.addRule(Reward.get(assets.findVehicleDefById("old-f1")), new ChampionshipRankRewardRule(Difficulty.HARD, assets.findChampionshipById("city"), 0));
        for (VehicleDef vehicleDef : assets.vehicleDefs) {
            Reward reward = Reward.get(vehicleDef);
            if (rewardManager.hasRuleForReward(reward)) continue;
            rewardManager.addRule(reward, RewardManager.ALWAYS_UNLOCKED);
        }
    }
}

