/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.bonus;

import com.agateau.pixelwheels.Renderer;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.bonus.BonusAdapter;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.utils.Pool;

public class TurboBonus
extends BonusAdapter
implements Pool.Poolable {
    private boolean mTriggered = false;
    private float mAnimationTime;
    private final Renderer mBonusRenderer = new Renderer(){

        @Override
        public void drawToCell(Batch batch, float centerX, float centerY) {
            TextureRegion region = TurboBonus.this.mAssets.turbo.getKeyFrame(TurboBonus.this.mAnimationTime, true);
            Vehicle vehicle = TurboBonus.this.mRacer.getVehicle();
            Body body = vehicle.getBody();
            float angle = body.getAngle() * 57.295776f;
            float w = region.getRegionWidth();
            float h = region.getRegionHeight();
            float refH = (float)(-vehicle.getRegion(0.0f).getRegionWidth()) / 3.0f;
            float x = centerX + refH * MathUtils.cosDeg(angle);
            float y = centerY + refH * MathUtils.sinDeg(angle);
            batch.draw(region, x - w / 2.0f, y - h / 2.0f, w / 2.0f, h / 2.0f, w, h, 1.0f, 1.0f, angle - 90.0f);
        }

        @Override
        public void draw(Batch batch, ZLevel zLevel) {
        }
    };

    public TurboBonus() {
        this.reset();
    }

    @Override
    public void reset() {
        this.mAnimationTime = 0.0f;
        this.mTriggered = false;
    }

    @Override
    public void onPicked(Racer racer) {
        super.onPicked(racer);
        this.mRacer.getVehicleRenderer().addRenderer(this.mBonusRenderer);
    }

    @Override
    public void onOwnerHit() {
        this.resetBonus();
    }

    @Override
    public void trigger() {
        if (!this.mTriggered) {
            this.mRacer.getVehicle().triggerTurbo();
            this.mTriggered = true;
        }
    }

    @Override
    public void act(float delta) {
        if (!this.mTriggered) {
            return;
        }
        this.mAnimationTime += delta;
        if (this.mAnimationTime > this.mAssets.turbo.getAnimationDuration()) {
            this.resetBonus();
        }
    }

    @Override
    public void aiAct(float delta) {
        this.mRacer.triggerBonus();
    }

    private void resetBonus() {
        this.mRacer.getVehicleRenderer().removeRenderer(this.mBonusRenderer);
        this.free();
        this.mRacer.resetBonus();
    }
}

