/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gameinput;

import com.agateau.pixelwheels.debug.Debug;
import com.agateau.pixelwheels.gameinput.GameInputHandlerFactory;
import com.agateau.pixelwheels.gameinput.GamepadInputHandler;
import com.agateau.pixelwheels.gameinput.KeyboardInputHandler;
import com.agateau.pixelwheels.gameinput.PieTouchInputHandler;
import com.agateau.pixelwheels.gameinput.SidesTouchInputHandler;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.utils.Array;

public class GameInputHandlerFactories {
    private static Array<GameInputHandlerFactory> sFactories;

    public static Array<GameInputHandlerFactory> getAvailableFactories() {
        GameInputHandlerFactories.init();
        return sFactories;
    }

    public static GameInputHandlerFactory getFactoryById(String id) {
        GameInputHandlerFactories.init();
        if ("".equals(id)) {
            GameInputHandlerFactory factory = sFactories.first();
            NLog.i("No input handler selected, using '%s'", factory.getId());
            return factory;
        }
        for (GameInputHandlerFactory factory : sFactories) {
            if (!factory.getId().equals(id)) continue;
            return factory;
        }
        NLog.e("Could not find an input handler factory with id '%s'", id);
        return sFactories.first();
    }

    public static boolean hasMultitouch() {
        return Gdx.input.isPeripheralAvailable(Input.Peripheral.MultitouchScreen) || Debug.instance.alwaysShowTouchInput;
    }

    private static void init() {
        if (sFactories != null) {
            return;
        }
        sFactories = new Array();
        if (GameInputHandlerFactories.hasMultitouch()) {
            sFactories.add(new PieTouchInputHandler.Factory());
            sFactories.add(new SidesTouchInputHandler.Factory());
        }
        sFactories.add(new KeyboardInputHandler.Factory());
        sFactories.add(new GamepadInputHandler.Factory());
    }
}

