/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.agateau.pixelwheels.map.LapPositionTable;
import com.agateau.utils.AgcMathUtils;
import com.agateau.utils.Assert;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.objects.PolylineMapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Polyline;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import java.util.HashSet;

public class LapPositionTableIO {
    public static Array<Line> loadSectionLines(TiledMap map) {
        MapLayer layer = map.getLayers().get("Sections");
        Assert.check(layer != null, "No 'Sections' layer found", new Object[0]);
        MapObjects objects = layer.getObjects();
        Array<Line> lines = new Array<Line>();
        lines.ensureCapacity(objects.getCount());
        HashSet<String> names = new HashSet<String>();
        for (MapObject obj : objects) {
            float order;
            String name = obj.getName();
            Assert.check(!name.isEmpty(), "Section line is missing a name", new Object[0]);
            Assert.check(!names.contains(name), "Duplicate section line " + name, new Object[0]);
            names.add(name);
            try {
                order = Float.parseFloat(name);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid section name " + name);
            }
            Assert.check(obj instanceof PolylineMapObject, "Object " + name + " in 'Sections' layer must be a PolylineMapObject", new Object[0]);
            Polyline polyline = ((PolylineMapObject)obj).getPolyline();
            float[] vertices = polyline.getTransformedVertices();
            Assert.check(vertices.length == 4, "Polyline " + name + " in 'Sections' layer should have 2 points, not " + vertices.length / 2, new Object[0]);
            Line line = new Line();
            line.p1.set(vertices[0], vertices[1]);
            line.p2.set(vertices[2], vertices[3]);
            line.order = order;
            lines.add(line);
        }
        lines.sort((l1, l2) -> Float.compare(l1.order, l2.order));
        return lines;
    }

    public static LapPositionTable load(TiledMap map) {
        Array<Line> lines = LapPositionTableIO.loadSectionLines(map);
        LapPositionTable table = new LapPositionTable();
        for (int idx = 0; idx < lines.size; ++idx) {
            Line line1 = lines.get(idx);
            Line line2 = lines.get((idx + 1) % lines.size);
            if (!AgcMathUtils.isQuadrilateralConvex(line1.p1, line2.p1, line2.p2, line1.p2)) {
                NLog.d("Quadrilateral formed by line %f and %f is concave, swapping points of line %f", Float.valueOf(line1.order), Float.valueOf(line2.order), Float.valueOf(line2.order));
                line2.swapPoints();
                if (!AgcMathUtils.isQuadrilateralConvex(line1.p1, line2.p1, line2.p2, line1.p2)) {
                    throw new RuntimeException("Quadrilateral formed by line " + line1.order + " and " + line2.order + " is concave");
                }
            }
            float[] vertices = new float[]{line1.p1.x, line1.p1.y, line2.p1.x, line2.p1.y, line2.p2.x, line2.p2.y, line1.p2.x, line1.p2.y};
            Polygon polygon = new Polygon(vertices);
            table.addSection(polygon);
        }
        return table;
    }

    public static class Line {
        public final Vector2 p1 = new Vector2();
        public final Vector2 p2 = new Vector2();
        public float order;

        public void swapPoints() {
            float x = this.p1.x;
            float y = this.p1.y;
            this.p1.set(this.p2);
            this.p2.set(x, y);
        }
    }
}

